/* module for the 1 player frenzy mode */

#include "includes.h"
#include "externs.h"

/* initialize the game to normal 1 player mode */
void initialize_1p_frenzy(void)
{
    cs_initialize_theme(&cs_theme);
    initialize_game(&cs_game[0], &cs_theme, 0, CS_1TF, 0, cs_options.level + 1);
    initialize_effect_blocks(&cs_effects_blocks);
    reset_clock(time_minutes_chart[cs_options.time_index], time_seconds_chart[cs_options.time_index]);
    game_quit = 0;
    beat_score = 0;
}

/* ready to exit game */
void exit_1p_frenzy(void)
{
    destroy_game(&cs_game[0]);
}

/* redraw the screen before starting */
void refresh_1p_frenzy(void)
{
    draw_bg();
    draw_game_paused(&cs_game[0], &cs_theme, &cs_clock);

    /* do transition if we're supposed to */
    if(cs_options.transitions)
    {
        clear(screen);
        set_palette(cs_theme.palette);
        t3ss_play_sound(cs_sound[SOUND_FADE_IN], 128, 22050);
        gef_pixelize_in(cs_theme.screen);
    }
    else
    {
        cs_screen_blit(cs_theme.screen, 0, 0);
        fade_in(cs_theme.palette, 3);
    }
}

/* play 1 player frenzy mode */
void play_1p_frenzy(void)
{
    /* get ready */
    initialize_1p_frenzy();
    refresh_1p_frenzy();
    game_count_down();

    /* start game */
    install_count_down_clock();
    install_int(core_drop_stack0, cs_game[0].drop_time);
    while(!game_quit && cs_game[0].state != STATE_GAMEOVER && cs_game[0].state != STATE_WIN)
    {
        if(key[KEY_ESC])
        {
            try_quit();
        }

        /* show message if you beat high score */
        if(cs_game[0].score >= cs_scores.frenzy_score[cs_options.time_index][0] && !beat_score)
        {
            queue_message(&cs_game[0].messages, 2, "            You got the high score");
            beat_score = 1;
        }

        /* move everything */
        cs_read_controls();
        core_game_step_normal(&cs_game[0], &cs_theme);
        if(cs_options.effects)
        {
            move_effect_blocks(&cs_theme, &cs_effects_blocks);
        }

        /* draw everything in memory */
        draw_bg();
        draw_game(&cs_game[0], &cs_theme, &cs_clock);
        if(cs_options.effects)
        {
            draw_effect_blocks(&cs_theme, &cs_effects_blocks);
        }

        cs_vsync();
        cs_screen_blit(cs_theme.screen, 0, 0);
    }

    /* stop game */
    remove_count_down_clock();
    remove_int(core_drop_stack0);
    game_over();

    /* ready to exit */
    t3ss_stop_mod();
    if(cs_options.transitions)
    {
        t3ss_play_sound(cs_sound[SOUND_FADE_OUT], 128, 22050);
        gef_pixelize_out(cs_theme.screen);
    }
    else
    {
        fade_out(3);
    }
    exit_1p_frenzy();
}
