#include "includes.h"
#include "externs.h"

/* resets the credits to contain nothing */
void clear_credit_list(CREDIT_LIST * lp)
{
    int i, j;

    /* deactivate all names and titles */
    for(i = 0; i < MAX_CREDITS; i++)
    {
        lp->credit[i].title.active = 0;
        for(j = 0; j < MAX_CREDIT_NAMES; j++)
        {
            lp->credit[i].name[j].active = 0;
        }
    }

    /* reset the counters so we don't try to read non-existent data */
    for(i = 0; i < lp->credit_count; i++)
    {
        lp->credit[i].name_count = 0;
    }
    lp->credit_count = 0;
}

/* add a credit to credit list */
void add_credit(CREDIT_LIST * lp, char * title)
{
    strcpy(lp->credit[lp->credit_count].title.text, title);
    lp->credit_count++;
}

/* add a name to credit list (adds to last added credit) */
void add_name(CREDIT_LIST * lp, char * name)
{
    strcpy(lp->credit[lp->credit_count - 1].name[lp->credit[lp->credit_count - 1].name_count].text, name);
    lp->credit[lp->credit_count - 1].name_count++;
}

/* draws all active credits */
void draw_credits(BITMAP * bp, CREDIT_LIST * lp)
{
    int i, j;

    for(i = 0; i < lp->credit_count; i++)
    {
        /* draw the title */
        if(lp->credit[i].title.active)
        {
            ncd_textout(bp, lp->title_font, (bp->w / 2) - (lp->title_font->w * strlen(lp->credit[i].title.text)) / 2 + lp->credit[i].title.x, lp->credit[i].title.y, lp->credit[i].title.text);
        }

        /* draw the names */
        for(j = 0; j < lp->credit[i].name_count; j++)
        {
            if(lp->credit[i].name[j].active)
            {
                ncd_textout(bp, lp->name_font, (bp->w / 2) - (lp->name_font->w * strlen(lp->credit[i].name[j].text)) / 2 + lp->credit[i].name[j].x, lp->credit[i].name[j].y, lp->credit[i].name[j].text);
            }
        }
    }
}

/* helper so we can skip credits if we want */
void credits_rest(int time)
{
    int i;

    /* rest in 10 millisecond intervals */
    for(i = 0; i < time / 10; i++)
    {
        /* keep reading the joystick */
        ncd_joy_poll();

        /* rest */
        rest(10);

        /* check for exit signal from user */
        if(key[KEY_ESC] || ncd_joy_button(0, 0) || ncd_joy_button(0, 1))
        {
            break;
        }
        t3ss_poll();
    }
}

/* show the credits */
void do_credits(CREDIT_LIST * lp)
{
    int i, j, k;
    int ty;
    int done = 0;
    int esc_pressed = 0;

    clear_keybuf();
    key[KEY_ESC] = 0;

    /* do all credits */
    for(i = 0; i < lp->credit_count && !done; i++)
    {
        /* center the title */
        lp->credit[i].title.active = 1;
        lp->credit[i].title.x = 0;
        ty = 120 - ((lp->credit[i].name_count * lp->name_font->h) + lp->title_font->h + 2) / 2;

        /* do we want fancy mode */
        if(cs_options.transitions)
        {
            /* fly title in */
            for(j = ty - 120; j <= ty; j += 4)
            {
                ncd_joy_poll();
                if(key[KEY_ESC] || ncd_joy_button(0, 0) || ncd_joy_button(0, 1))
                {
                    esc_pressed = 1;
                }
                lp->credit[i].title.y = j;
                blit(cs_menu_bg_image, screen_buffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
                draw_credits(screen_buffer, lp);
                vsync();
                cs_screen_blit(screen_buffer, 0, 0);
		        t3ss_poll();
            }

            /* fly names in */
            for(j = 0; j < lp->credit[i].name_count; j++)
            {
                t3ss_play_sound(cs_sound[SOUND_MENU_SWOOSH], 128, 22050);
                lp->credit[i].name[j].active = 1;
                lp->credit[i].name[j].y = lp->credit[i].title.y + lp->title_font->h + 2 + lp->title_font->h * j;
                lp->credit[i].name[j].x = j % 2 ? -320 : 320;

                for(k = 0; k <= 320; k += 16)
                {
                    ncd_joy_poll();
                    if(key[KEY_ESC] || ncd_joy_button(0, 0) || ncd_joy_button(0, 1))
                    {
                        esc_pressed = 1;
                    }
                    lp->credit[i].name[j].x = j % 2 ? k - 320 : 320 - k;
                    blit(cs_menu_bg_image, screen_buffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
                    draw_credits(screen_buffer, lp);
                    vsync();
                    cs_screen_blit(screen_buffer, 0, 0);
			        t3ss_poll();
                }
            }
            if(!esc_pressed)
            {
                credits_rest(3000);
            }

            /* fly names out */
            for(j = 0; j < lp->credit[i].name_count; j++)
            {
                t3ss_play_sound(cs_sound[SOUND_MENU_SWOOSH], 128, 22050);
                for(k = 320; k >= 0; k -= 16)
                {
                    ncd_joy_poll();
                    if(key[KEY_ESC] || ncd_joy_button(0, 0) || ncd_joy_button(0, 1))
                    {
                        esc_pressed = 1;
                    }
                    lp->credit[i].name[j].x = j % 2 ? 320 - k : k - 320;
                    blit(cs_menu_bg_image, screen_buffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
                    draw_credits(screen_buffer, lp);
                    vsync();
                    cs_screen_blit(screen_buffer, 0, 0);
			        t3ss_poll();
                }
                lp->credit[i].name[j].active = 0;
            }

            /* fly title out */
            for(j = ty; j >= ty - 120; j -= 4)
            {
                ncd_joy_poll();
                if(key[KEY_ESC] || ncd_joy_button(0, 0) || ncd_joy_button(0, 1))
                {
                    esc_pressed = 1;
                }
                lp->credit[i].title.y = j;
                blit(cs_menu_bg_image, screen_buffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
                draw_credits(screen_buffer, lp);
                vsync();
                cs_screen_blit(screen_buffer, 0, 0);
		        t3ss_poll();
            }
            lp->credit[i].title.active = 0;
            if(esc_pressed)
            {
                done = 1;
            }
        }

        /* or fast mode */
        else
        {
            ty = 120 - ((lp->credit[i].name_count * lp->name_font->h) + lp->title_font->h + 2) / 2;

            /* place title */
            lp->credit[i].title.active = 1;
            lp->credit[i].title.x = 0;
            lp->credit[i].title.y = ty;

            /* place names */
            for(j = 0; j < lp->credit[i].name_count; j++)
            {
                lp->credit[i].name[j].active = 1;
                lp->credit[i].name[j].y = lp->credit[i].title.y + lp->title_font->h + 2 + lp->name_font->h * j;
                lp->credit[i].name[j].x = 0;
            }

            /* draw credit */
            blit(cs_menu_bg_image, screen_buffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
            draw_credits(screen_buffer, lp);
            vsync();
            cs_screen_blit(screen_buffer, 0, 0);

            /* rest */
            credits_rest(3000);

            /* see if user wants out */
            ncd_joy_poll();
            if(key[KEY_ESC] || ncd_joy_button(0, 0) || ncd_joy_button(0, 1))
            {
                done = 1;
            }

            /* deactivate the credit */
            lp->credit[i].title.active = 0;
            for(j = 0; j < lp->credit[i].name_count; j++)
            {
                lp->credit[i].name[j].active = 0;
            }
        }
    }
}
