#ifndef CORE_H
#define CORE_H

#include "types.h"

#define BLOCKS_PER_LEVEL 45
#define WILD_SHIFT        2

/* stuff used by outside modules */
void core_delete_block(CS_GAME * gp, CS_THEME * tp, int boardx, int boardy, int boardwidth, int boardheight);
void core_replace_block(CS_GAME * gp, CS_THEME * tp, int boardx, int boardy, int Block);
void core_insert_solid_row(CS_GAME * gp);
int core_test_block(CS_GAME * gp, CS_THEME * tp, int boardx, int boardy);
void core_drop_stack(CS_GAME * gp, CS_THEME * tp);
void core_drop_stack0(void);
void core_drop_stack1(void);
void core_copy_stack(CS_GAME * gp);
void core_generate_stack(CS_GAME * gp, CS_THEME * tp);
void core_find_runs(CS_GAME * gp, CS_THEME * tp);
void core_handle_runs_normal(CS_GAME * gp, CS_THEME * tp);
void core_handle_runs_battle(CS_GAME * gp1, CS_GAME * gp2, CS_THEME * tp);
void core_handle_wild_card(CS_GAME * gp);
void core_game_step_normal(CS_GAME * gp, CS_THEME * tp);
void core_game_step_battle(CS_GAME * gp1, CS_GAME * gp2, CS_THEME * tp);
void core_update_level(CS_GAME * gp, CS_THEME * tp);
void core_handle_game_over(CS_GAME * gp, CS_THEME * tp);
void core_handle_win(CS_GAME * gp, CS_THEME * tp);
void core_movement(CS_GAME * gp, CS_THEME * tp);

#endif
