#include "includes.h"
#include "externs.h"

#define REPEAT_DELAY 14
#define REPEAT_SPEED  7

/* gets player inputs */
void cs_read_controls(void)
{
    int i;

    /* poll the joystick */
    ncd_joy_poll();

    /* controls for each player */
    for(i = 0; i < 2; i++)
    {
        /* read left buttons */
        if((key[cs_controls[i].left] || ncd_joy_left(i)) && cs_game[i].control.was_left < 1)
        {
            cs_game[i].control.left = 1;
            cs_game[i].control.was_left++;
        }
        else if((key[cs_controls[i].left] || ncd_joy_left(i)) && cs_game[i].control.was_left >= 1 && cs_game[i].control.was_left < REPEAT_DELAY)
        {
            cs_game[i].control.left = 0;
            cs_game[i].control.was_left++;
        }
        else
        {
            if(cs_game[i].control.was_left % REPEAT_SPEED == 0)
            {
                cs_game[i].control.left = 1;
            }
            else
            {
                cs_game[i].control.left = 0;
            }
            cs_game[i].control.was_left++;
        }
        if(!key[cs_controls[i].left] && !ncd_joy_left(i))
        {
            cs_game[i].control.left = 0;
            cs_game[i].control.was_left = 0;
        }
        
        /* read right buttons */
        if((key[cs_controls[i].right] || ncd_joy_right(i)) && cs_game[i].control.was_right < 1)
        {
            cs_game[i].control.right = 1;
            cs_game[i].control.was_right++;
        }
        else if((key[cs_controls[i].right] || ncd_joy_right(i)) && cs_game[i].control.was_right >= 1 && cs_game[i].control.was_right < REPEAT_DELAY)
        {
            cs_game[i].control.right = 0;
            cs_game[i].control.was_right++;
        }
        else
        {
            if(cs_game[i].control.was_right % REPEAT_SPEED == 0)
            {
                cs_game[i].control.right = 1;
            }
            else
            {
                cs_game[i].control.right = 0;
            }
            cs_game[i].control.was_right++;
        }
        if(!key[cs_controls[i].right] && !ncd_joy_right(i))
        {
            cs_game[i].control.right = 0;
            cs_game[i].control.was_right = 0;
        }
        
        /* read drop buttons */
        if((key[cs_controls[i].drop] || ncd_joy_down(i)) && !cs_game[i].control.was_drop)
        {
            cs_game[i].control.drop = 1;
        }
        else
        {
            cs_game[i].control.drop = 0;
        }
        if(!key[cs_controls[i].drop] && !ncd_joy_down(i))
        {
            cs_game[i].control.was_drop = 0;
        }
        
        /* read rotate up buttons */
        if((key[cs_controls[i].rup] || ncd_joy_button(i, 0) || ncd_joy_button(i, 2)) && !cs_game[i].control.was_rotate_up)
        {
            cs_game[i].control.rotate_up = 1;
            cs_game[i].control.was_rotate_up = 1;
        }
        else
        {
            cs_game[i].control.rotate_up = 0;
        }
        if(!key[cs_controls[i].rup] && !ncd_joy_button(i, 0) && !ncd_joy_button(i, 2))
        {
            cs_game[i].control.rotate_up = 0;
            cs_game[i].control.was_rotate_up = 0;
        }
        
        /* read rotate down buttons */
        if((key[cs_controls[i].rdown] || ncd_joy_button(i, 1)) && !cs_game[i].control.was_rotate_down)
        {
            cs_game[i].control.rotate_down = 1;
            cs_game[i].control.was_rotate_down = 1;
        }
        else
        {
            cs_game[i].control.rotate_down = 0;
        }
        if(!key[cs_controls[i].rdown] && !ncd_joy_button(i, 1))
        {
            cs_game[i].control.rotate_down = 0;
            cs_game[i].control.was_rotate_down = 0;
        }
    }
}
