#include "includes.h"


void view_theme(void)
{
        int i, j, k;

        update_proc();
        fade_out(3);
        set_gfx_mode(Theme.Card, Theme.ResX, Theme.ResY, Theme.ResX, Theme.ResY);
        set_palette(black_palette);

        clear(screen);
        if(Theme.MapWidth > 0 && Theme.MapHeight > 0 && Theme.TileWidth > 0 && Theme.TileHeight > 0)
        {
                for(i = 0; i < Theme.MapHeight; i++)
                {
                        for(j = 0; j < Theme.MapWidth; j++)
                        {
                                blit(Theme.Tile[Theme.BGMapData[i * Theme.MapWidth + j]], screen, 0, 0, j * Theme.TileWidth, i * Theme.TileHeight, Theme.ResX, Theme.ResY);
                        }
                }
        }
        else
        {
                blit(Theme.BGPic, screen, 0, 0, 0, 0, Theme.ResX, Theme.ResY);
        }
        for(k = 0; k < MAX_PLAYERS; k++)
        {
                for(i = 0; i < Theme.BoardHeight; i++)
                {
                        for(j = 0; j < Theme.BoardWidth; j++)
                        {
                                if(i > Theme.BoardHeight / 2)

                                        draw_sprite(screen, Theme.Block[rand() % 6 + 1], Theme.BoardX[k] + j * Theme.BlockWidth, Theme.BoardY[k] + i * Theme.BlockHeight);

                                else

                                        draw_sprite(screen, Theme.Block[0], Theme.BoardX[k] + j * Theme.BlockWidth, Theme.BoardY[k] + i * Theme.BlockHeight);
                        }
                }
        }
        for(k = 0; k < MAX_PLAYERS; k++)
        {
                ncd_draw_number(screen, &Theme.Font, Theme.ScoreX[k], Theme.ScoreY[k], rand() % 99999, 5);
                ncd_draw_number(screen, &Theme.Font, Theme.LevelX[k], Theme.LevelY[k], rand() % 99, 2);
                ncd_draw_number(screen, &Theme.Font, Theme.BlockX[k], Theme.BlockY[k], rand() % 9999, 4);
                ncd_printf(screen, &Theme.Font, Theme.PMessageX[k], Theme.PMessageY[k], "-PMESSAGE%d--", k);
        }
        ncd_draw_number(screen, &Theme.Font, Theme.HighScoreX, Theme.HighScoreY, rand() % 99999, 5);

        ncd_draw_number(screen, &Theme.Font, Theme.ClockX, Theme.ClockY, rand() % 99, 2);
        ncd_printf(screen, &Theme.Font, Theme.ClockX, Theme.ClockY, "  :");
        ncd_draw_number(screen, &Theme.Font, Theme.ClockX + Theme.Font.w * 3, Theme.ClockY, rand() % 60, 2);

        ncd_draw_number(screen, &Theme.Font, Theme.BestTimeX, Theme.BestTimeY, rand() % 99, 2);
        ncd_printf(screen, &Theme.Font, Theme.BestTimeX, Theme.BestTimeY, "  :");
        ncd_draw_number(screen, &Theme.Font, Theme.BestTimeX + Theme.Font.w * 3, Theme.BestTimeY, rand() % 60, 2);

        ncd_printf(screen, &Theme.Font, Theme.MessageX, Theme.MessageY, "--MESSAGE:--");

        for(i = 0; i < MAX_PLAYERS; i++)
        {
                draw_sprite(screen, Theme.Block[rand() % 5 + 1], Theme.NextX[i], Theme.NextY[i]);
                draw_sprite(screen, Theme.Block[rand() % 5 + 1], Theme.NextX[i], Theme.NextY[i] + Theme.BlockHeight);
                draw_sprite(screen, Theme.Block[rand() % 5 + 1], Theme.NextX[i], Theme.NextY[i] + 2 * Theme.BlockHeight);
        }

        fade_in(Theme.Palette, 3);
        while(!key[KEY_ESC] && !key[KEY_ENTER] && !key[KEY_SPACE]);
        while(key[KEY_ESC] || key[KEY_ENTER] || key[KEY_SPACE]);
        fade_out(3);
        set_gfx_mode(GFX_AUTODETECT, 320, 200, 320, 200);
        set_palette(black_palette);
        update_proc();
        fade_in(ce_palette, 3);
}
