#include "includes.h"


void te_export(void)
{
        char TempFileName[256];
        int i, j, k;
        PACKFILE * file;

        /* set file selector color */
        gui_bg_color = Window[selected_window].hbg;
        gui_fg_color = Window[selected_window].hfg;

        strcpy(TempFileName, "");
        if(!file_select_ex("Enter tileset filename...", TempFileName, "TST", 256, SCREEN_W, SCREEN_H))
        {
                while(key[KEY_ESC] || key[KEY_ENTER]);
                return;
        }

        replace_extension(TempFileName, TempFileName, "TST", 256);

        file = pack_fopen(TempFileName, "w");

        pack_putc(Theme.TileWidth, file);
        pack_putc(Theme.TileHeight, file);

        for(i = 0; i < NUM_BG_TILES; i++)
        {
                for(j = 0; j < Theme.TileHeight; j++)
                {
                        for(k = 0; k < Theme.TileWidth; k++)
                        {
                                pack_putc(Theme.Tile[i]->line[j][k], file);
                        }
                }
        }
        pack_fclose(file);
}


void te_import(void)
{
        char TempFileName[256];
        int i, j, k;
        PACKFILE * file;

        /* set file selector color */
        gui_bg_color = Window[selected_window].hbg;
        gui_fg_color = Window[selected_window].hfg;

        strcpy(TempFileName, "");
        if(!file_select_ex("Choose tileset file...", TempFileName, "TST", 256, SCREEN_W, SCREEN_H))
        {
                while(key[KEY_ESC] || key[KEY_ENTER]);
                return;
        }

        file = pack_fopen(TempFileName, "r");

        Theme.TileWidth = pack_getc(file);
        Theme.TileHeight = pack_getc(file);

        for(i = 0; i < NUM_BG_TILES; i++)
        {
                for(j = 0; j < Theme.TileHeight; j++)
                {
                        for(k = 0; k < Theme.TileWidth; k++)
                        {
                                Theme.Tile[i]->line[j][k] = pack_getc(file);
                        }
                }
        }
        pack_fclose(file);
}


void te_grab(void)
{
        char TempFileName[256];

        /* set file selector color */
        gui_bg_color = Window[selected_window].hbg;
        gui_fg_color = Window[selected_window].hfg;

        memset(TempFileName, 0, 256);
        if(!file_select_ex("Select file to grab from...", TempFileName, "PCX", 256, SCREEN_W, SCREEN_H))
        {
                while(key[KEY_ESC] || key[KEY_ENTER]);
                return;
        }

        grab_image(Theme.Tile[selected_image], TempFileName);
}


void te_init(void)
{
        int i;

        fade_out(3);

        destroy_bitmap(screen_buffer);
        set_gfx_mode(GFX_AUTODETECT, Theme.ResX, Theme.ResY, Theme.ResX, Theme.ResY);
        clear(screen);
        set_palette(black_palette);
        screen_buffer = create_bitmap(Theme.ResX, Theme.ResY);

        /* point update_proc to the right place */
        update_proc = te_update;

        /* deactivate all the windows */
        for(i = 0; i < WINDOWS; i++)
        {
                deactivate_window(&Window[i]);
        }

        /* set up and activate file window */
        clear_menu(&Window[WINDOW_FILE]);
//        set_window_color(&Window[WINDOW_FILE], GUI_BG, GUI_FG, GUI_HBG, GUI_HFG, GUI_MHBG, GUI_MHFG);
        add_menu_item(&Window[WINDOW_FILE], "Import", -1, te_import);
        add_menu_item(&Window[WINDOW_FILE], "Export", -1, te_export);
        add_menu_item(&Window[WINDOW_FILE], "Grab", -1, te_grab);
        set_window_position(&Window[WINDOW_FILE], screen_buffer->w - Window[WINDOW_FILE].w - 10, 35);
        select_window(&Window[WINDOW_FILE]);
        selected_window = WINDOW_FILE;
        make_closest(ce_zbuffer, WINDOW_FILE, WINDOWS);
        activate_window(&Window[WINDOW_FILE]);

        /* get editor windows ready */
        delete_image(&Window[WINDOW_ISELECT]);
        import_image(&Window[WINDOW_ISELECT], create_bitmap(5 * Theme.TileWidth, 8 * Theme.TileHeight));
        clear(Window[WINDOW_ISELECT].dat.iw.image);
        delete_image(&Window[WINDOW_IEDIT]);
        import_image(&Window[WINDOW_IEDIT], create_bitmap(Theme.TileWidth * edit_scale, Theme.TileHeight * edit_scale));
        clear(Window[WINDOW_IEDIT].dat.iw.image);

        /* activate the editor windows */
        set_window_position(&Window[WINDOW_ISELECT], 47, 35);
        activate_window(&Window[WINDOW_ISELECT]);
        set_window_position(&Window[WINDOW_IEDIT], Window[WINDOW_ISELECT].x + Window[WINDOW_ISELECT].w + 1, Window[WINDOW_ISELECT].y);
        activate_window(&Window[WINDOW_IEDIT]);

        /* set other variables */
        selected_image = 0;
        copy_image = 0;
        selected_tool = TOOLTYPE_BRUSH;

        update_proc();
        fade_in(Theme.Palette, 3);

        edited = 1;
}


void te_exit(void)
{
        fade_out(3);

        /* reset editor */
        reset_ce();

        update_proc();
        fade_in(ce_palette, 3);

        /* grab escape press */
        while(key[KEY_ESC])

                update_proc();
}


/* function called by the edit menu */
void edit_tiles(void)
{
        if(Theme.TileWidth > 0 && Theme.TileHeight > 0 && Theme.MapWidth > 0 && Theme.MapHeight > 0)
        {
                te_init();
                while(!key[KEY_ESC])
                {
                        ce_control();
                        te_control();
                        update_proc();
                }
                while(key[KEY_ESC]);

                te_exit();
        }
        else;
}


void te_update(void)
{
        int i;

        clear(Window[WINDOW_ISELECT].dat.iw.image);

        for(i = 0; i < NUM_BG_TILES; i++)

                blit(Theme.Tile[i], Window[WINDOW_ISELECT].dat.iw.image, 0, 0, (i % 5) * Theme.TileWidth, (i / 5) * Theme.TileHeight, Window[WINDOW_ISELECT].dat.iw.image->w, Window[WINDOW_ISELECT].dat.iw.image->h);

        if(highlight)

                rect(Window[WINDOW_ISELECT].dat.iw.image, selected_image % 5 * Theme.TileWidth, selected_image / 5 * Theme.TileHeight, selected_image % 5 * Theme.TileWidth + Theme.TileWidth - 1, selected_image / 5 * Theme.TileHeight + Theme.TileHeight - 1, Window[selected_window].bg);

        highlight ^= 1;

        stretch_blit(Theme.Tile[selected_image], Window[WINDOW_IEDIT].dat.iw.image, 0, 0, Theme.TileWidth, Theme.TileHeight, 0, 0, Theme.TileWidth * edit_scale, Theme.TileHeight * edit_scale);

        redraw_gui_edit();
}


void te_control(void)
{
        int pegx, pegy;

        /* update pegs for drawing tools */
        pegx = mouse_x;
        pegy = mouse_y;

        select_tool();
        select_color();

        if(mouse_b & 1)
        {

                /* select tile if clicking on tile display window */
                if(selected_window == WINDOW_ISELECT && mouse_x > Window[WINDOW_ISELECT].x && mouse_x < Window[WINDOW_ISELECT].x + Window[WINDOW_ISELECT].w && mouse_y > Window[WINDOW_ISELECT].y + 10 && mouse_y < Window[WINDOW_ISELECT].y + Window[WINDOW_ISELECT].h)
                {
                        selected_image = (mouse_x - (Window[WINDOW_ISELECT].x + 1)) / Theme.TileWidth + (((mouse_y - (Window[WINDOW_ISELECT].y + 11)) / Theme.TileHeight) * 5);
                        if(selected_image > 39)

                                selected_image = 39;
                }

                /* draw using selected tool if clicking on edit window */
                if(selected_window == WINDOW_IEDIT && mouse_x > Window[WINDOW_IEDIT].x + 1 && mouse_x < Window[WINDOW_IEDIT].x + Window[WINDOW_IEDIT].w - 1 && mouse_y > Window[WINDOW_IEDIT].y + 11 && mouse_y < Window[WINDOW_IEDIT].y + Window[WINDOW_IEDIT].h - 1)
                {
                        if(selected_tool == TOOLTYPE_BRUSH)

                                DoBrush(Theme.Tile[selected_image], (mouse_x - (Window[WINDOW_IEDIT].x + 1)) / edit_scale, (mouse_y - (Window[WINDOW_IEDIT].y + 11)) / edit_scale, left_color);

                        else if(selected_tool == TOOLTYPE_DROPPER)

                                left_color = DoDropper(Theme.Tile[selected_image], (mouse_x - (Window[WINDOW_IEDIT].x + 1)) / edit_scale, (mouse_y - (Window[WINDOW_IEDIT].y + 11)) / edit_scale);

                        else if(selected_tool == TOOLTYPE_ERASE)

                                DoErase(Theme.Tile[selected_image], left_color);

                        else if(selected_tool == TOOLTYPE_FILL)

                                DoFill(Theme.Tile[selected_image], (mouse_x - (Window[WINDOW_IEDIT].x + 1)) / edit_scale, (mouse_y - (Window[WINDOW_IEDIT].y + 11)) / edit_scale, left_color);

                        else if(selected_tool == TOOLTYPE_REPLACE)

                                DoReplace(Theme.Tile[selected_image], (mouse_x - (Window[WINDOW_IEDIT].x + 1)) / edit_scale, (mouse_y - (Window[WINDOW_IEDIT].y + 11)) / edit_scale, left_color);

                        else if(selected_tool == TOOLTYPE_LINE)

                                DoLine(Theme.Tile[selected_image], 1, pegx, pegy, (Window[WINDOW_IEDIT].x + 1), (Window[WINDOW_IEDIT].y + 11), edit_scale, left_color, update_proc);

                        else if(selected_tool == TOOLTYPE_RECT)

                                DoRect(Theme.Tile[selected_image], 1, pegx, pegy, (Window[WINDOW_IEDIT].x + 1), (Window[WINDOW_IEDIT].y + 11), edit_scale, left_color, update_proc);

                        else if(selected_tool == TOOLTYPE_FRECT)

                                DoFRect(Theme.Tile[selected_image], 1, pegx, pegy, (Window[WINDOW_IEDIT].x + 1), (Window[WINDOW_IEDIT].y + 11), edit_scale, left_color, update_proc);

                        else if(selected_tool == TOOLTYPE_CIRCLE)

                                DoCircle(Theme.Tile[selected_image], 1, pegx, pegy, (Window[WINDOW_IEDIT].x + 1), (Window[WINDOW_IEDIT].y + 11), edit_scale, left_color, update_proc);

                        else if(selected_tool == TOOLTYPE_FCIRCLE)

                                DoFCircle(Theme.Tile[selected_image], 1, pegx, pegy, (Window[WINDOW_IEDIT].x + 1), (Window[WINDOW_IEDIT].y + 11), edit_scale, left_color, update_proc);
                }
        }
        if(mouse_b & 2)
        {
                /* draw using selected tool if clicking on edit window */
                if(selected_window == WINDOW_IEDIT && mouse_x > Window[WINDOW_IEDIT].x + 1 && mouse_x < Window[WINDOW_IEDIT].x + Window[WINDOW_IEDIT].w - 1 && mouse_y > Window[WINDOW_IEDIT].y + 11 && mouse_y < Window[WINDOW_IEDIT].y + Window[WINDOW_IEDIT].h - 1)
                {
                        if(selected_tool == TOOLTYPE_BRUSH)

                                DoBrush(Theme.Tile[selected_image], (mouse_x - (Window[WINDOW_IEDIT].x + 1)) / edit_scale, (mouse_y - (Window[WINDOW_IEDIT].y + 11)) / edit_scale, right_color);

                        else if(selected_tool == TOOLTYPE_DROPPER)

                                right_color = DoDropper(Theme.Tile[selected_image], (mouse_x - (Window[WINDOW_IEDIT].x + 1)) / edit_scale, (mouse_y - (Window[WINDOW_IEDIT].y + 11)) / edit_scale);

                        else if(selected_tool == TOOLTYPE_ERASE)

                                DoErase(Theme.Tile[selected_image], right_color);

                        else if(selected_tool == TOOLTYPE_FILL)

                                DoFill(Theme.Tile[selected_image], (mouse_x - (Window[WINDOW_IEDIT].x + 1)) / edit_scale, (mouse_y - (Window[WINDOW_IEDIT].y + 11)) / edit_scale, right_color);

                        else if(selected_tool == TOOLTYPE_REPLACE)

                                DoReplace(Theme.Tile[selected_image], (mouse_x - (Window[WINDOW_IEDIT].x + 1)) / edit_scale, (mouse_y - (Window[WINDOW_IEDIT].y + 11)) / edit_scale, right_color);

                        else if(selected_tool == TOOLTYPE_LINE)

                                DoLine(Theme.Tile[selected_image], 2, pegx, pegy, (Window[WINDOW_IEDIT].x + 1), (Window[WINDOW_IEDIT].y + 11), edit_scale, right_color, update_proc);

                        else if(selected_tool == TOOLTYPE_RECT)

                                DoRect(Theme.Tile[selected_image], 2, pegx, pegy, (Window[WINDOW_IEDIT].x + 1), (Window[WINDOW_IEDIT].y + 11), edit_scale, right_color, update_proc);

                        else if(selected_tool == TOOLTYPE_FRECT)

                                DoFRect(Theme.Tile[selected_image], 2, pegx, pegy, (Window[WINDOW_IEDIT].x + 1), (Window[WINDOW_IEDIT].y + 11), edit_scale, right_color, update_proc);

                        else if(selected_tool == TOOLTYPE_CIRCLE)

                                DoCircle(Theme.Tile[selected_image], 2, pegx, pegy, (Window[WINDOW_IEDIT].x + 1), (Window[WINDOW_IEDIT].y + 11), edit_scale, right_color, update_proc);

                        else if(selected_tool == TOOLTYPE_FCIRCLE)

                                DoFCircle(Theme.Tile[selected_image], 2, pegx, pegy, (Window[WINDOW_IEDIT].x + 1), (Window[WINDOW_IEDIT].y + 11), edit_scale, right_color, update_proc);
                }
        }

        if(key[KEY_C])

                copy_image = selected_image;

        if(key[KEY_P])

                blit(Theme.Tile[copy_image], Theme.Tile[selected_image], 0, 0, 0, 0, Theme.TileWidth, Theme.TileHeight);

        if(key[KEY_MINUS] && edit_scale > 4)
        {
                edit_scale--;
                delete_image(&Window[WINDOW_IEDIT]);
                import_image(&Window[WINDOW_IEDIT], create_bitmap(Theme.TileWidth * edit_scale, Theme.TileHeight * edit_scale));
                deselect_all();
                select_window(&Window[WINDOW_IEDIT]);
                selected_window = WINDOW_IEDIT;
                make_closest(ce_zbuffer, WINDOW_IEDIT, WINDOWS);
                while(key[KEY_MINUS]);
        }
        if(key[KEY_EQUALS])
        {
                edit_scale++;
                delete_image(&Window[WINDOW_IEDIT]);
                import_image(&Window[WINDOW_IEDIT], create_bitmap(Theme.TileWidth * edit_scale, Theme.TileHeight * edit_scale));
                deselect_all();
                select_window(&Window[WINDOW_IEDIT]);
                selected_window = WINDOW_IEDIT;
                make_closest(ce_zbuffer, WINDOW_IEDIT, WINDOWS);
                while(key[KEY_EQUALS]);
        }
        if(key[KEY_UP])
        {
                if(selected_image >= 10)

                        selected_image -= 10;

                while(key[KEY_UP]);
        }
        if(key[KEY_DOWN])
        {
                if(selected_image < 30)

                        selected_image += 10;

                while(key[KEY_DOWN]);
        }
        if(key[KEY_LEFT])
        {
                if(selected_image > 0)

                        selected_image--;

                while(key[KEY_LEFT]);
        }
        if(key[KEY_RIGHT])
        {
                if(selected_image < 39)

                        selected_image++;

                while(key[KEY_RIGHT]);
        }
}
