#ifndef SOUND_H
#define SOUND_H

#include <allegro.h>

#ifdef __cplusplus
extern "C" {
#endif

#define NCDS_MOD    void
#define NCDS_SAMPLE SAMPLE

/* sound system channel modes */
#define NCDS_CH_MONO           0
#define NCDS_CH_STEREO         1
#define NCDS_CH_REVERSE_STEREO 2

extern int ncds_num_patterns;

/* initialization functions */
int ncds_install(long freq, int stereo);
void ncds_remove(void);
void ncds_set_effects_channels(int number);
void ncds_set_reserved_channels(int number);
void ncds_enable_effects(void);
void ncds_enable_music(void);
void ncds_disable_effects(void);
void ncds_disable_music(void);
void ncds_set_music_volume(int volume);
void ncds_set_sound_volume(int volume);

/* loading functions */
NCDS_MOD * ncds_load_mod_fp(PACKFILE * fp);
NCDS_MOD * ncds_load_mod(char * fn);
void ncds_destroy_mod(NCDS_MOD * mp);
NCDS_SAMPLE * ncds_load_wav_fp(PACKFILE * fp);
NCDS_SAMPLE * ncds_load_wav(char * fn);
int ncds_save_wav_fp(NCDS_SAMPLE * sp, PACKFILE * fp);
int ncds_save_wav(NCDS_SAMPLE * sp, char * fn);
void ncds_free_sample(NCDS_SAMPLE * sp);

/* playing functions */
int ncds_play_mod(NCDS_MOD * mp);
void ncds_stop_mod(void);
void ncds_set_music_pattern(int patnum);
void ncds_play_sound(NCDS_SAMPLE * sp, int pan);
void ncds_play_sound_ex(NCDS_SAMPLE * sp, int chan, int vol, int pan, int freq);
void ncds_play_sound_reserved(NCDS_SAMPLE * sp, int chan, int pan, int freq);
int ncds_place_sound(int x, int width);

#ifdef __cplusplus
}
#endif

#endif
