#include "includes.h"

int LEDMode = 0;
char * LEDModeText[16] = {"P1Board", "P1Score", "P1Next", "P1Level", "P1Block", "P1Message", "P2Board", "P2Score", "P2Next", "P2Level", "P2Block", "P2Message", "Clock", "High", "BestTime", "Message"};
int PlayerNumArray[16] = {0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0};
int led_flip = 0;

void le_init(void)
{
        int i;

        fade_out(3);

        destroy_bitmap(screen_buffer);
        set_gfx_mode(GFX_AUTODETECT, Theme.ResX, Theme.ResY, Theme.ResX, Theme.ResY);
        clear(screen);
        set_palette(black_palette);
        screen_buffer = create_bitmap(Theme.ResX, Theme.ResY);

        /* point update_proc to the right place */
        update_proc = le_update;

        /* deactivate all the windows */
        for(i = 0; i < WINDOWS; i++)
        {
                deactivate_window(&Window[i]);
        }

        update_proc();
        fade_in(Theme.Palette, 3);

        edited = 1;
}


void le_exit(void)
{
        fade_out(3);

        /* reset editor */
        reset_ce();

        update_proc();
        fade_in(ce_palette, 3);

        /* grab escape press */
        while(key[KEY_ESC])

                update_proc();
}


/* function called by the edit menu */
void edit_layout(void)
{
        le_init();
        while(!key[KEY_ESC])
        {
//                ce_control();
                le_control();
                update_proc();
        }
        while(key[KEY_ESC]);

        le_exit();
}


void le_update(void)
{
        int i, j, k;

        clear(Theme.ScreenBuffer);
        if(Theme.MapWidth > 0 && Theme.MapHeight > 0 && Theme.TileWidth > 0 && Theme.TileHeight > 0)
        {
                for(i = 0; i < Theme.MapHeight; i++)
                {
                        for(j = 0; j < Theme.MapWidth; j++)
                        {
                                blit(Theme.Tile[Theme.BGMapData[i * Theme.MapWidth + j]], Theme.ScreenBuffer, 0, 0, j * Theme.TileWidth, i * Theme.TileHeight, Theme.ResX, Theme.ResY);
                        }
                }
        }
        else
        {
                blit(Theme.BGPic, Theme.ScreenBuffer, 0, 0, 0, 0, Theme.ResX, Theme.ResY);
        }
        for(k = 0; k < MAX_PLAYERS; k++){
                for(i = 0; i < Theme.BoardHeight; i++){
                        for(j = 0; j < Theme.BoardWidth; j++){
                                masked_blit(Theme.Block[rand() % 5 + 1], Theme.ScreenBuffer, 0, 0, Theme.BoardX[k] + j * Theme.BlockWidth, Theme.BoardY[k] + i * Theme.BlockHeight, Theme.ResX, Theme.ResY);
                                }
                        }
                }
        for(k = 0; k < MAX_PLAYERS; k++){
                ncd_draw_number(Theme.ScreenBuffer, &Theme.Font, Theme.ScoreX[k], Theme.ScoreY[k], rand() % 99999, 5);
                ncd_draw_number(Theme.ScreenBuffer, &Theme.Font, Theme.LevelX[k], Theme.LevelY[k], rand() % 99, 2);
                ncd_draw_number(Theme.ScreenBuffer, &Theme.Font, Theme.BlockX[k], Theme.BlockY[k], rand() % 9999, 4);
                ncd_printf(Theme.ScreenBuffer, &Theme.Font, Theme.PMessageX[k], Theme.PMessageY[k], "-PMESSAGE%d--", k);
                }
        ncd_draw_number(Theme.ScreenBuffer, &Theme.Font, Theme.HighScoreX, Theme.HighScoreY, rand() % 99999, 5);

        ncd_draw_number(Theme.ScreenBuffer, &Theme.Font, Theme.ClockX, Theme.ClockY, rand() % 99, 2);
        ncd_printf(Theme.ScreenBuffer, &Theme.Font, Theme.ClockX, Theme.ClockY, "  :");
        ncd_draw_number(Theme.ScreenBuffer, &Theme.Font, Theme.ClockX + Theme.Font.w * 3, Theme.ClockY, rand() % 60, 2);

        ncd_draw_number(Theme.ScreenBuffer, &Theme.Font, Theme.BestTimeX, Theme.BestTimeY, rand() % 99, 2);
        ncd_printf(Theme.ScreenBuffer, &Theme.Font, Theme.BestTimeX, Theme.BestTimeY, "  :");
        ncd_draw_number(Theme.ScreenBuffer, &Theme.Font, Theme.BestTimeX + Theme.Font.w * 3, Theme.BestTimeY, rand() % 60, 2);

        ncd_printf(Theme.ScreenBuffer, &Theme.Font, Theme.MessageX, Theme.MessageY, "--MESSAGE:--");

        for(i = 0; i < MAX_PLAYERS; i++){
                draw_sprite(Theme.ScreenBuffer, Theme.Block[1], Theme.NextX[i], Theme.NextY[i]);
                draw_sprite(Theme.ScreenBuffer, Theme.Block[1], Theme.NextX[i], Theme.NextY[i] + Theme.BlockHeight);
                draw_sprite(Theme.ScreenBuffer, Theme.Block[1], Theme.NextX[i], Theme.NextY[i] + 2 * Theme.BlockHeight);
                }

        if(LEDMode == 0 && led_flip)
        {
            rect(Theme.ScreenBuffer, Theme.BoardX[0], Theme.BoardY[0], Theme.BoardX[0] + Theme.BoardWidth * Theme.BlockWidth - 1, Theme.BoardY[0] + Theme.BoardHeight * Theme.BlockHeight - 1, makecol(255, 255, 255));
        }
        if(LEDMode == 1 && led_flip)
        {
            rect(Theme.ScreenBuffer, Theme.ScoreX[0], Theme.ScoreY[0], Theme.ScoreX[0] + 5 * Theme.Font.w - 1, Theme.ScoreY[0] + Theme.Font.h - 1, makecol(255, 255, 255));
        }
        if(LEDMode == 2 && led_flip)
        {
            rect(Theme.ScreenBuffer, Theme.NextX[0], Theme.NextY[0], Theme.NextX[0] + Theme.BlockWidth - 1, Theme.NextY[0] + 3 * Theme.BlockHeight - 1, makecol(255, 255, 255));
        }
        if(LEDMode == 3 && led_flip)
        {
            rect(Theme.ScreenBuffer, Theme.LevelX[0], Theme.LevelY[0], Theme.LevelX[0] + 2 * Theme.Font.w - 1, Theme.LevelY[0] + Theme.Font.h - 1, makecol(255, 255, 255));
        }
        if(LEDMode == 4 && led_flip)
        {
            rect(Theme.ScreenBuffer, Theme.BlockX[0], Theme.BlockY[0], Theme.BlockX[0] + 4 * Theme.Font.w - 1, Theme.BlockY[0] + Theme.Font.h - 1, makecol(255, 255, 255));
        }
        if(LEDMode == 5 && led_flip)
        {
            rect(Theme.ScreenBuffer, Theme.PMessageX[0], Theme.PMessageY[0], Theme.PMessageX[0] + 12 * Theme.Font.w - 1, Theme.PMessageY[0] + Theme.Font.h - 1, makecol(255, 255, 255));
        }
        if(LEDMode == 6 && led_flip)
        {
            rect(Theme.ScreenBuffer, Theme.BoardX[1], Theme.BoardY[1], Theme.BoardX[1] + Theme.BoardWidth * Theme.BlockWidth - 1, Theme.BoardY[1] + Theme.BoardHeight * Theme.BlockHeight - 1, makecol(255, 255, 255));
        }
        if(LEDMode == 7 && led_flip)
        {
            rect(Theme.ScreenBuffer, Theme.ScoreX[1], Theme.ScoreY[1], Theme.ScoreX[1] + 5 * Theme.Font.w - 1, Theme.ScoreY[1] + Theme.Font.h - 1, makecol(255, 255, 255));
        }
        if(LEDMode == 8 && led_flip)
        {
            rect(Theme.ScreenBuffer, Theme.NextX[1], Theme.NextY[1], Theme.NextX[1] + Theme.BlockWidth - 1, Theme.NextY[1] + 3 * Theme.BlockHeight - 1, makecol(255, 255, 255));
        }
        if(LEDMode == 9 && led_flip)
        {
            rect(Theme.ScreenBuffer, Theme.LevelX[1], Theme.LevelY[1], Theme.LevelX[1] + 2 * Theme.Font.w - 1, Theme.LevelY[1] + Theme.Font.h - 1, makecol(255, 255, 255));
        }
        if(LEDMode == 10 && led_flip)
        {
            rect(Theme.ScreenBuffer, Theme.BlockX[1], Theme.BlockY[1], Theme.BlockX[1] + 4 * Theme.Font.w - 1, Theme.BlockY[1] + Theme.Font.h - 1, makecol(255, 255, 255));
        }
        if(LEDMode == 11 && led_flip)
        {
            rect(Theme.ScreenBuffer, Theme.PMessageX[1], Theme.PMessageY[1], Theme.PMessageX[1] + 12 * Theme.Font.w - 1, Theme.PMessageY[1] + Theme.Font.h - 1, makecol(255, 255, 255));
        }
        if(LEDMode == 12 && led_flip)
        {
            rect(Theme.ScreenBuffer, Theme.ClockX, Theme.ClockY, Theme.ClockX + 5 * Theme.Font.w - 1, Theme.ClockY + Theme.Font.h - 1, makecol(255, 255, 255));
        }
        if(LEDMode == 13 && led_flip)
        {
            rect(Theme.ScreenBuffer, Theme.HighScoreX, Theme.HighScoreY, Theme.HighScoreX + 5 * Theme.Font.w - 1, Theme.HighScoreY + Theme.Font.h - 1, makecol(255, 255, 255));
        }
        if(LEDMode == 14 && led_flip)
        {
            rect(Theme.ScreenBuffer, Theme.BestTimeX, Theme.BestTimeY, Theme.BestTimeX + 5 * Theme.Font.w - 1, Theme.BestTimeY + Theme.Font.h - 1, makecol(255, 255, 255));
        }
        if(LEDMode == 15 && led_flip)
        {
            rect(Theme.ScreenBuffer, Theme.MessageX, Theme.MessageY, Theme.MessageX + 12 * Theme.Font.w - 1, Theme.MessageY + Theme.Font.h - 1, makecol(255, 255, 255));
        }
        ncd_printf(Theme.ScreenBuffer, &Theme.Font, 1, Theme.ResY - Theme.Font.h - 1, "Mode: %s", LEDModeText[LEDMode]);
        led_flip = 1 - led_flip;

        blit(Theme.ScreenBuffer, screen, 0, 0, 0, 0, Theme.ResX, Theme.ResY);
}


void le_control(void)
{
        if(key[KEY_UP])
        {
                if(LEDMode == 0 || LEDMode == 6)

                        Theme.BoardY[PlayerNumArray[LEDMode]]--;

                else if(LEDMode == 1 || LEDMode == 7)

                        Theme.ScoreY[PlayerNumArray[LEDMode]]--;

                else if(LEDMode == 2 || LEDMode == 8)

                        Theme.NextY[PlayerNumArray[LEDMode]]--;

                else if(LEDMode == 3 || LEDMode == 9)

                        Theme.LevelY[PlayerNumArray[LEDMode]]--;

                else if(LEDMode == 4 || LEDMode == 10)

                        Theme.BlockY[PlayerNumArray[LEDMode]]--;

                else if(LEDMode == 5 || LEDMode == 11)

                        Theme.PMessageY[PlayerNumArray[LEDMode]]--;

                else if(LEDMode == 12)

                        Theme.ClockY--;

                else if(LEDMode == 13)

                        Theme.HighScoreY--;

                else if(LEDMode == 14)

                        Theme.BestTimeY--;

                else

                        Theme.MessageY--;

                if(!key[KEY_LSHIFT])
		{
			clear_keybuf();
		}
        }
        if(key[KEY_DOWN])
        {
                if(LEDMode == 0 || LEDMode == 6)

                        Theme.BoardY[PlayerNumArray[LEDMode]]++;

                else if(LEDMode == 1 || LEDMode == 7)

                        Theme.ScoreY[PlayerNumArray[LEDMode]]++;

                else if(LEDMode == 2 || LEDMode == 8)

                        Theme.NextY[PlayerNumArray[LEDMode]]++;

                else if(LEDMode == 3 || LEDMode == 9)

                        Theme.LevelY[PlayerNumArray[LEDMode]]++;

                else if(LEDMode == 4 || LEDMode == 10)

                        Theme.BlockY[PlayerNumArray[LEDMode]]++;

                else if(LEDMode == 5 || LEDMode == 11)

                        Theme.PMessageY[PlayerNumArray[LEDMode]]++;

                else if(LEDMode == 12)

                        Theme.ClockY++;

                else if(LEDMode == 13)

                        Theme.HighScoreY++;

                else if(LEDMode == 14)

                        Theme.BestTimeY++;

                else

                        Theme.MessageY++;

                if(!key[KEY_LSHIFT])
		{
			clear_keybuf();
		}
        }
        if(key[KEY_LEFT])
        {
                if(LEDMode == 0 || LEDMode == 6)

                        Theme.BoardX[PlayerNumArray[LEDMode]]--;

                else if(LEDMode == 1 || LEDMode == 7)

                        Theme.ScoreX[PlayerNumArray[LEDMode]]--;

                else if(LEDMode == 2 || LEDMode == 8)

                        Theme.NextX[PlayerNumArray[LEDMode]]--;

                else if(LEDMode == 3 || LEDMode == 9)

                        Theme.LevelX[PlayerNumArray[LEDMode]]--;

                else if(LEDMode == 4 || LEDMode == 10)

                        Theme.BlockX[PlayerNumArray[LEDMode]]--;

                else if(LEDMode == 5 || LEDMode == 11)

                        Theme.PMessageX[PlayerNumArray[LEDMode]]--;

                else if(LEDMode == 12)

                        Theme.ClockX--;

                else if(LEDMode == 13)

                        Theme.HighScoreX--;

                else if(LEDMode == 14)

                        Theme.BestTimeX--;

                else

                        Theme.MessageX--;

                if(!key[KEY_LSHIFT])
		{
			clear_keybuf();
		}
        }
        if(key[KEY_RIGHT])
        {
                if(LEDMode == 0 || LEDMode == 6)

                        Theme.BoardX[PlayerNumArray[LEDMode]]++;

                else if(LEDMode == 1 || LEDMode == 7)

                        Theme.ScoreX[PlayerNumArray[LEDMode]]++;

                else if(LEDMode == 2 || LEDMode == 8)

                        Theme.NextX[PlayerNumArray[LEDMode]]++;

                else if(LEDMode == 3 || LEDMode == 9)

                        Theme.LevelX[PlayerNumArray[LEDMode]]++;

                else if(LEDMode == 4 || LEDMode == 10)

                        Theme.BlockX[PlayerNumArray[LEDMode]]++;

                else if(LEDMode == 5 || LEDMode == 11)

                        Theme.PMessageX[PlayerNumArray[LEDMode]]++;

                else if(LEDMode == 12)

                        Theme.ClockX++;

                else if(LEDMode == 13)

                        Theme.HighScoreX++;

                else if(LEDMode == 14)

                        Theme.BestTimeX++;

                else

                        Theme.MessageX++;

                if(!key[KEY_LSHIFT])
		{
			clear_keybuf();
		}
        }
        if(key[KEY_TAB])
        {
                if(LEDMode >= 15)

                        LEDMode = 0;

                else

                        LEDMode++;

                while(key[KEY_TAB]);
        }
}
