#include "includes.h"

int hide_windows = 0;

void bge_export(void)
{
        char TempFileName[256];
        PACKFILE * file;

        if(!file_select_ex("Enter map filename...", TempFileName, "MAP", 256, SCREEN_W, SCREEN_H))
        {
                while(key[KEY_ESC] || key[KEY_ENTER]);
                return;
        }

        replace_extension(TempFileName, TempFileName, "MAP", 256);

        file = pack_fopen(TempFileName, "w");

        pack_fwrite(Theme.BGMapData, Theme.MapWidth * Theme.MapHeight, file);

        pack_fclose(file);
}


void bge_import(void)
{
        char TempFileName[256];
        PACKFILE * file;

        if(!file_select_ex("Enter map filename...", TempFileName, "MAP", 256, SCREEN_W, SCREEN_H))
        {
                while(key[KEY_ESC] || key[KEY_ENTER]);
                return;
        }

        file = pack_fopen(TempFileName, "r");

        pack_fread(Theme.BGMapData, Theme.MapWidth * Theme.MapHeight, file);

        pack_fclose(file);
}


void grab_background(void)
{
        char FileName[256];
        BITMAP * TempPic;

        memset(FileName, 0, 256);

        if(file_select_ex("Choose background image...", FileName, "PCX", 256, SCREEN_W, SCREEN_H))
        {
                TempPic = load_pcx(FileName, Theme.Palette);
                stretch_blit(TempPic, Theme.BGPic, 0, 0, TempPic->w, TempPic->h, 0, 0, Theme.ResX, Theme.ResY);
                destroy_bitmap(TempPic);
                edited = 1;
        }
        ce_convert();
        while(key[KEY_ENTER] || key[KEY_ESC] || key[KEY_SPACE]);
}


void bge_init(void)
{
        int i;

        fade_out(3);

        destroy_bitmap(screen_buffer);
        set_gfx_mode(GFX_AUTODETECT, Theme.ResX, Theme.ResY, Theme.ResX, Theme.ResY);
        set_palette(Theme.Palette);
        screen_buffer = create_bitmap(Theme.ResX, Theme.ResY);

        /* point update_proc to the right place */
        update_proc = bge_update;

        /* deactivate all the windows */
        for(i = 0; i < WINDOWS; i++)
        {
                deactivate_window(&Window[i]);
        }

        /* set up and activate file window */
        clear_menu(&Window[WINDOW_FILE]);
        set_window_color(&Window[WINDOW_FILE], GUI_BG, GUI_FG, GUI_HBG, GUI_HFG, GUI_MHBG, GUI_MHFG);
        add_menu_item(&Window[WINDOW_FILE], "Import", -1, bge_import);
        add_menu_item(&Window[WINDOW_FILE], "Export", -1, bge_export);
        set_window_position(&Window[WINDOW_FILE], screen_buffer->w - Window[WINDOW_FILE].w - 10, 35);
        select_window(&Window[WINDOW_FILE]);
        selected_window = WINDOW_FILE;
        make_closest(ce_zbuffer, WINDOW_FILE, WINDOWS);
        activate_window(&Window[WINDOW_FILE]);

        /* get editor windows ready */
        destroy_window(&Window[WINDOW_ISELECT]);
        create_window(&Window[WINDOW_ISELECT], TYPE_IMAGE, "Pics");
        import_image(&Window[WINDOW_ISELECT], create_bitmap(5 * Theme.TileWidth, 8 * Theme.TileHeight));
        clear(Window[WINDOW_ISELECT].dat.iw.image);

        /* activate the editor windows */
        set_window_position(&Window[WINDOW_ISELECT], 47, 35);
        activate_window(&Window[WINDOW_ISELECT]);

        /* set other variables */
        selected_image = 0;

        update_proc();
        fade_in(Theme.Palette, 3);

        edited = 1;
}


void bge_exit(void)
{
        fade_out(3);

        /* reset editor */
        reset_ce();

        update_proc();
        fade_in(ce_palette, 3);

        /* grab escape press */
        while(key[KEY_ESC])

                update_proc();
}


void bge_update(void)
{
        int i, j;

        clear(Window[WINDOW_ISELECT].dat.iw.image);
        for(i = 0; i < NUM_BG_TILES; i++)

                blit(Theme.Tile[i], Window[WINDOW_ISELECT].dat.iw.image, 0, 0, i % (5) * Theme.TileWidth, i / (5) * Theme.TileHeight, Window[WINDOW_ISELECT].dat.iw.image->w, Window[WINDOW_ISELECT].dat.iw.image->h);

        if(highlight)

                rect(Window[WINDOW_ISELECT].dat.iw.image, (selected_image % 5) * Theme.TileWidth, (selected_image / 5) * Theme.TileHeight, (selected_image % 5) * Theme.TileWidth + Theme.TileWidth - 1, (selected_image / 5) * Theme.TileHeight + Theme.TileHeight - 1, Window[WINDOW_FILE].bg);

        highlight ^= 1;

        clear(Theme.ScreenBuffer);

        for(i = 0; i < Theme.MapHeight; i++)

                for(j = 0; j < Theme.MapWidth; j++)

                        blit(Theme.Tile[Theme.BGMapData[i * Theme.MapWidth + j]], Theme.ScreenBuffer, 0, 0, j * Theme.TileWidth, i * Theme.TileHeight, Theme.ResX, Theme.ResY);

        /* draw all the windows */
        for(i = 0; i < WINDOWS; i++)

                draw_window(&Window[ce_zbuffer[i]], Theme.ScreenBuffer);

        /* draw the mouse */
        draw_sprite(Theme.ScreenBuffer, cursor, mouse_x, mouse_y);

        /* copy to hardware screen */
        vsync();
        blit(Theme.ScreenBuffer, screen, 0, 0, 0, 0, screen->w, screen->h);
}


void bge_control(void)
{
        if(key[KEY_F2])
        {
                if(hide_windows)
                {
                        hide_windows = 0;
                        activate_window(&Window[WINDOW_ISELECT]);
                        activate_window(&Window[WINDOW_FILE]);
                }
                else
                {
                        hide_windows = 1;
                        deactivate_window(&Window[WINDOW_ISELECT]);
                        deactivate_window(&Window[WINDOW_FILE]);
                }
                while(key[KEY_F2]);
        }

        if(mouse_b & 1)
        {

                if(selected_window == WINDOW_ISELECT && Window[selected_window].active && mouse_x > Window[WINDOW_ISELECT].x && mouse_x < Window[WINDOW_ISELECT].x + Window[WINDOW_ISELECT].w && mouse_y > Window[WINDOW_ISELECT].y + 10 && mouse_y < Window[WINDOW_ISELECT].y + Window[WINDOW_ISELECT].h)
                {
                        selected_image = (mouse_x - (Window[WINDOW_ISELECT].x + 1)) / Theme.TileWidth + (((mouse_y - (Window[WINDOW_ISELECT].y + 11)) / Theme.TileHeight) * 5);
                        if(selected_image > 39)

                                selected_image = 39;
                }

                else

                        Theme.BGMapData[(mouse_y / Theme.TileHeight) * Theme.MapWidth + mouse_x / Theme.TileWidth] = selected_image;
        }
}


void edit_background(void)
{
        bge_init();
        while(!key[KEY_ESC])
        {
                ce_control();
                bge_control();
                update_proc();
        }
        bge_exit();
}


void gui_background(void)
{
        if(Theme.TileWidth > 0 && Theme.TileHeight > 0 && Theme.MapWidth > 0 && Theme.MapHeight > 0)
        {
                edit_background();

        }
        else
        {
                grab_background();
        }
}
