/*   ______   ___    ___
    /\  _  \ /\_ \  /\_ \                             
    \ \ \L\ \\//\ \ \//\ \      __     __   _ __   ___ 
     \ \  __ \ \ \ \  \ \ \   /'__`\ /'_ `\/\`'__\/ __`\
      \ \ \/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
       \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
        \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/ \/___/
                                       /\____/
    Allegro Low-Level Game Routines    \_/__/   Version 4.2.0
         
         Arena Football using Dev-Cpp 4.9.9.2  (c) 2006 by Gia T. Nguyen */

// Header File:    football.h
// Last Modified:  04/12/2006

#include <allegro.h>

#define DATA "football.dat"

#define GRASS makecol(47,152,47)
#define GREEN makecol(0,255,0)                
#define RED makecol(255,0,0)
#define BLUE makecol(0,0,255)
#define LIGHT_BLUE makecol(64,64,255)
#define YELLOW makecol(255,255,0)
#define BLACK makecol(0,0,0)
#define WHITE makecol(255,255,255)

#define SCREEN_X 20
#define SCREEN_Y 80

#define VOLUME 100

#define GOAL 1

#define BMP_SIZE 24
#define BMP_CENTER 12
#define BALL_ZONE 12
#define BALL_OFFSET 6
#define PLAYER_OFFSET 6
#define PLAYER_ZONE 12
#define OUTBOUND_OFFSET 5
#define YARD_MARKER 60
#define CENTER 115

#define FRAME 6

enum Formations {
     RUN,
     PASS
};

enum Teams {
     HOME,
     VISITOR
};

enum Players {
     OPLAYERS = 4,
     DPLAYERS = 6
};

enum Direction {
     MOVEUP = 1,
     MOVEDOWN = 2,
     MOVERIGHT = 3,
     MOVELEFT = 4
};

enum CollideResults {
     DOWN = -1,
     STOP = 0,
     FREE = 1,
     BACKUP = 2,
     INTERCEPT = 3,
     COMPLETE = 4,
     INCOMPLETE = 5,
     THROWN = 6
};

enum PlayerRole {
     OFFENSE,
     DEFENSE
};

enum PlayerNum {
     p1,
     p2,
     p3,
     p4,
     p5,
     p6
};

enum Speed {
     RUNNER = 5,
     BLOCKER = 5,
     SAFETY = 20,
     BALL = 20,
     KICKBALL = 10
};
        
typedef struct Zone {
     int x1;
     int y1;
     int x2;
     int y2;
};

enum PlayerMode {
     SINGLE = 1,
     DOUBLE = 2,
     VERSUS = 3
};

enum FieldSectors {
     YRD20 = 20,
     FIRST_DOWN = 10,
     RED_ZONE = 10,
     RED_ZONE2 = 90,
     RED_ZONE3 = 95,
     FG_RANGE = 45,
     MID_FIELD = 50,
     TD_ZONE = 100,
     END_DOWN = 0
};

enum Downs {
     FIRST = 1,
     SECOND = 2,
     THIRD = 3,
     FOURTH = 4
};

enum Scores {
     TD = 7,
     FG = 3,
     SF = 2
};

enum BitMapPos {
     RUN_SPRITE,
     BLOCK_SPRITE,
     PASS_SPRITE,
     DEF_SPRITE,
     KICK_SPRITE
};

DATAFILE *dat;
BITMAP *hsrc, *vsrc, *buffer, *stat, *msg;
MIDI *music = NULL;
FONT *font_yard, *font_label, *font_score, *font_msg, *font_big, *font_label2;

int frame_idx=0;
int hscore=0, vscore=0;
int down=FIRST;
int togo=FIRST_DOWN;
int yard=YRD20;
int scrimmage=YRD20;
int start=0;
int num_players=SINGLE;
int turn=HOME;
int music_flag=1;
int formation=RUN;
int pass_ret=FREE;
int down_yard=END_DOWN;

Zone display_zone = {0,0,600,250};
Zone field_zone = {100,0,1300,250};

int rndgen(int rndmax);            
int yards(int yard);               
int xyards(int x);                 
bool inbound(int x, int y);        

int rndgen(int rndmax) {
    
    if (rndmax == 0) {
        srand(time(NULL));
        return(0);
    } else
    return rand() % rndmax;

}

int yards(int yard) {

    return 100 + (yard/5)*YARD_MARKER;
         
}

int xyards(int x) {
    
    return (x-100)/12;
    
}

bool inbound(int x, int y) {
     
     if ((x > field_zone.x1 && 
          x < field_zone.x2) && 
         (y > field_zone.y1+OUTBOUND_OFFSET && 
          y < field_zone.y2-OUTBOUND_OFFSET))
          return true;
     else
          return false;
          
}
    
class CPlayer {

private:

    int moveup();
    int movedown();
    int moveright();
    int moveleft();
    int check_collide(int x, int y);
    bool collide(int x, int y, CPlayer player);
    
public:

    BITMAP *image[FRAME];   
    bool reverse;
    bool ball_carrier;
    int x;
    int y;
    int speed;
    int role;
    int number;

    CPlayer();
    ~CPlayer();
    int move(int direction, int formation);
    int move(int formation);

};

CPlayer offense[4], defense[6], kicker;

CPlayer::CPlayer() {
                       
     speed = BLOCKER;
     x = 0;
     y = 0;
     reverse = false;
     ball_carrier = false;
     
}

CPlayer::~CPlayer() {

}

int CPlayer::moveup() {
    
    if (!inbound(x,y-speed)) {
      if (role == OFFENSE && number == p1)
         return DOWN;
      else
         return STOP;
    }
    int res = check_collide(x,y-speed);    
    if (res != FREE) return res;     
    y -= speed;
    return res;
    
}

int CPlayer::movedown() {
    
    if (!inbound(x,y+speed)){
      if (role == OFFENSE && number == p1)
         return DOWN;
      else
         return STOP;
    }
    int res = check_collide(x,y+speed);    
    if (res != FREE) return res;   
    y += speed;
    return res;
    
}

int CPlayer::moveleft() {

    if (!inbound(x-speed,y)){
      if (role == OFFENSE && offense[number].ball_carrier)
         return DOWN;
      else
         return STOP;
    }
    int res = check_collide(x-speed,y);    
    if (res != FREE) return res;   
    x -= speed;
    return res;
}

int CPlayer::moveright() {

    if (!inbound(x+speed,y)){
      if (role == OFFENSE && offense[number].ball_carrier)
         return DOWN;
      else
         return STOP;
    }   
    int res = check_collide(x+speed,y);    
    if (res != FREE) return res;
    x += speed;
    return res;
    
}

int CPlayer::check_collide(int x, int y) {
    
    int p = p1;
    if (offense[p2].ball_carrier) p = p2;
    
    switch (role) {
       case OFFENSE:
            for (int i=p1;i<DPLAYERS;i++)
                if (collide(x,y,defense[i])) {       
                    if (number == p) return DOWN;
                    return STOP;
                }

            for (int j=p1;j<OPLAYERS;j++)
                if (j != number)
                   if (collide(x,y,offense[j]))
                       return STOP;

            break;
       case DEFENSE:
            for (int i=p1;i<OPLAYERS;i++) 
                if (collide(x,y,offense[i])) {
                     if (i == p) return DOWN;
                     return BACKUP;
                }

            for (int j=p1;j<DPLAYERS;j++)
                 if (j != number) 
                     if (collide(x,y,defense[j]))                  
                         return BACKUP;
                         
            break;
    }
    return FREE;
    
}

int CPlayer::move(int formation) {
    
    return move(0,formation);

}

int CPlayer::move(int direction, int formation) {
    
    int res = FREE;
    int i = p1;
    if (offense[p2].ball_carrier) i=p2;
        
    switch (role) {
           case DEFENSE:
                if (num_players == VERSUS && number == p1) {
                    switch (direction) {
                      case MOVEUP:
                           return moveup();
                           break;
                      case MOVEDOWN:
                           return movedown();
                           break;
                      case MOVERIGHT:
                           reverse = true;
                           return moveright();
                           break;
                      case MOVELEFT:
                           reverse = false;
                           return moveleft();
                           break;
                   }                                
                } else {
                    if (x < offense[i].x) {
                        reverse = true;
                        res = moveright();
                        if (y >= offense[i].y) res = moveup();
                        if (y < offense[i].y) res = movedown();
                    } else {
                        switch (number) {
                               case p2:
                               case p3:
                               case p4:
                                    if (x >= offense[i].x) {
                                       reverse = false;
                                       res = moveleft();
                                    }
                                    if (y >= offense[i].y) res = moveup();
                                    if (y < offense[i].y) res = movedown();
                                    break;
                               case p1:
                               case p5:
                               case p6:
                                    int defense_play = 0;
                                    if (formation == RUN) defense_play = rndgen(3);
                                    switch (defense_play) {
                                           case 0:
                                                if (x >= offense[i].x && offense[i].x > x - YARD_MARKER*2) {
                                                   reverse = false;
                                                   res = moveleft();
                                                   switch (number) {
                                                          case p1:
                                                                if (y >= offense[i].y) res = moveup();
                                                                if (y < offense[i].y) res = movedown();
                                                                break;
                                                          case p5:
                                                                if (y >= offense[i].y && offense[p1].y <= CENTER) res = moveup();
                                                                if (y < offense[i].y && offense[p1].y <= CENTER) res = movedown();
                                                                break;
                                                          case p6:
                                                                if (y >= offense[i].y && offense[p1].y > CENTER) res = moveup();
                                                                if (y < offense[i].y && offense[p1].y > CENTER) res = movedown();
                                                                break;
                                                   }
                                                }
                                                break;
                                           case 1:
                                                switch (number) {
                                                       case p1:
                                                            if (x >= offense[i].x && offense[i].x > x - YARD_MARKER*2) {
                                                               reverse = false;
                                                               res = moveleft();
                                                               if (y >= offense[i].y) res = moveup();
                                                               if (y < offense[i].y) res = movedown();
                                                            }
                                                            break;
                                                       case p5:
                                                       case p6:
                                                           if (x >= offense[i].x && offense[i].x > x - YARD_MARKER*3) {
                                                               reverse = false;
                                                               res = moveleft();
                                                           }
                                                           if (number == p5) {
                                                                if (y >= offense[i].y && offense[i].y <= CENTER) res = moveup();
                                                                if (y < offense[i].y && offense[i].y <= CENTER) res = movedown();
                                                           }
                                                           if (number == p6) {
                                                                if (y >= offense[i].y && offense[i].y > CENTER) res = moveup();
                                                                if (y < offense[i].y && offense[i].y > CENTER) res = movedown();
                                                           }
                                                           break;
                                                }
                                                break;
                                           case 2:
                                                if (number == p1) {
                                                    if (x >= offense[i].x && offense[i].x > x - YARD_MARKER*2) {
                                                       reverse = false;
                                                       res = moveleft();
                                                       if (y >= offense[i].y) res = moveup();
                                                       if (y < offense[i].y) res = movedown();
                                                    }
                                                } else {
                                                   if (x >= offense[i].x) {
                                                       reverse = false;
                                                       res = moveleft();
                                                   }
                                                   if (y >= offense[i].y) res = moveup();
                                                   if (y < offense[i].y) res = movedown();
                                                }
                                                break;
                                           case 3:
                                                if (x >= offense[i].x) {
                                                       reverse = false;
                                                       res = moveleft();
                                                }       
                                                if (y >= offense[i].y) res = moveup();
                                                if (y < offense[i].y) res = movedown();
                                                break;
                                    }
                                    break;
                        }                            
                    }    
                    if (res == BACKUP) {
                        res = moveright();
                        if (x < CENTER)
                            res = moveup();
                        else
                            res = movedown();
                    }
                }
                return res;
                break;
           case OFFENSE:
                if (number > p1) {
                    if (formation == PASS && number == p2) {
                        if (y >= offense[p1].y) moveup();
                        if (y < offense[p1].y) movedown();
                    } else {                   
                        if (x > defense[number].x) {
                              reverse = true;
                              moveleft();
                        }      
                        if (y >= defense[number].y) moveup();
                        if (y < defense[number].y) movedown();
                        if (x <= defense[number].x) {
                              reverse = false;
                              moveright();
                        }
                    }          
                } else {
                   switch (direction) {
                      case MOVEUP:
                           return moveup();
                           break;
                      case MOVEDOWN:
                           return movedown();
                           break;
                      case MOVERIGHT:
                           reverse = false;
                           return moveright();
                           break;
                      case MOVELEFT:
                           if (formation == PASS && number == p1)
                              reverse = true;
                           return moveleft();
                           break;
                   }
                }                
                break;
    }
}

bool CPlayer::collide(int x, int y, CPlayer player) {

    int left1 = x + PLAYER_OFFSET;
    int left2 = player.x + PLAYER_OFFSET;
    int right1 = left1 + PLAYER_ZONE;
    int right2 = left2 + PLAYER_ZONE;
    int top1 = y + PLAYER_OFFSET;
    int top2 = player.y + PLAYER_OFFSET;
    int bottom1 = top1 + PLAYER_ZONE;
    int bottom2 = top2 + PLAYER_ZONE;

    if (top1 > bottom2 || 
        top2 > bottom1 ||
        left1 > right2 || 
        left2 > right1)
        return false;
    else
        return true;
    
}

class CBall {

private:
    
    int goal_x;
    int goal_y;
    int check_collide(int x, int y);
    bool collide(int x, int y, CPlayer player);
    
public:
    
    BITMAP *image;
    int x;
    int y;
    
    CBall();
    ~CBall();  
    int pass();
    int kick();
    int move(); 
                 
};

CBall fball;

CBall::CBall() {
                       
     x = 0;
     y = 0;
     goal_x = 0;
     goal_y = CENTER;     
}

CBall::~CBall() {

} 

bool CBall::collide(int x, int y, CPlayer player) {
     
    int left1 = x;
    int left2 = player.x + BALL_OFFSET;
    int right1 = x + image->w;
    int right2 = left2 + BALL_ZONE;
    int top1 = y;
    int top2 = player.y + BALL_OFFSET;
    int bottom1 = y + image->h;
    int bottom2 = top2 + BALL_ZONE;     
    
    if (top1 > bottom2 || 
        top2 > bottom1 || 
        left1 > right2 || 
        left2 > right1)
        return false;
    else
        return true;

}

int CBall::move() {
    
    if (x < goal_x) x += KICKBALL;
    if (y < goal_y) y ++;
    if (y > goal_y) y --;
    if (x >= goal_x)
       return 1;
    else
       return 0;
    
}

int CBall::check_collide(int x, int y) {
    
    for (int i=p1;i<DPLAYERS;i++)
        if (collide(x,y,defense[i])) {
           if (!defense[i].reverse)       
               return INTERCEPT;
           else
               return INCOMPLETE;
        }           
    
    for (int j=p1;j<OPLAYERS;j++)
        if (collide(x,y,offense[j])) {
           if (j == p1 && offense[j].reverse)
               return COMPLETE;
           else
               return INCOMPLETE;
        }
        
    
    return THROWN;
    
}

int CBall::pass() {

    int res = check_collide(x+BALL,y);    
    if (res != THROWN) return res;
    x += BALL;
    if (x > offense[p1].x+BMP_SIZE) return INCOMPLETE;
    return res;
    
}

int CBall::kick() {
    
    int chance;
    y = CENTER;
    
    goal_x = x + 540;
    if (goal_x > 1350) goal_x = 1350;
    
    if (yard >= FG_RANGE && yard < 55) chance = rndgen(5);
    if (yard >= 55 && yard < 65) chance = rndgen(4);
    if (yard >= 65 && yard < 75) chance = rndgen(3);
    if (yard >= 75 && yard < 85) chance = rndgen(2);
    if (yard >= 85) chance = GOAL;

    switch (chance) {
           case 0:
                goal_y = CENTER-YARD_MARKER/3;
                break;
           case GOAL:
                goal_y = CENTER;
                break;
           case 2:
                goal_y = CENTER-YARD_MARKER/2;
                break;
           case 3:
                goal_y = CENTER+YARD_MARKER/3;
                break;
           case 4:
                goal_y = CENTER+YARD_MARKER/2;
                break;     
    }
    
    return chance;
    
}

void init(int graphics);
bool play();
void deinit();
void init_game();
void draw_field();
void draw_field(int formation);
void draw_lines();
void run_formation(int x);
void pass_formation(int x);
void kick_formation(int x);
void draw_player(CPlayer player);
void draw_player(CPlayer player,bool reverse);
void draw_players();
void draw_ball(int angle);
void play_music(int toggle);
void load_fonts();
void load_bitmaps();
void load_bitmaps(int turn);
void load_bitmaps2(int turn, int formation);
void switch_bitmaps(int turn, int player);
void draw_header();
void draw_labels();
void draw_scores();
void send_msg();
void send_msg(char *message);
void send_scoreboard(char *message);
void new_down();
void new_down(bool start_over);
void auto_play();
void pass();
void kick_fieldgoal();
void move_frame();
void move_frame(int frame);
void reset_formation();
void pause_game();
void pause_game(char *msg,bool wait);
void pause();
void clear_field();
void draw_instruction();
void get_bmp(int turn, int frame);
void get_bmp(int turn, int type,int number, int frame);
void select_mode(int display);
void refresh();




