#include "sheep.h"

void get_views() {
 BITMAP *view[4];
 switch (n_players) {
  case 4:
   {
    int xm=gfx_w>>1;
    int ym=gfx_h>>1;
    view[0]=create_sub_bitmap(scrbuf,0,0,xm,ym);
    view[1]=create_sub_bitmap(scrbuf,0,ym+1,xm,ym-1);
    view[2]=create_sub_bitmap(scrbuf,xm+1,ym+1,xm-1,ym-1);
    view[3]=create_sub_bitmap(scrbuf,xm+1,0,xm-1,ym);
   }
   break;
  case 3:
   {
    int xm=gfx_w>>1;
    int xq=(xm+1)>>1;
    int ym=gfx_h>>1;
    view[0]=create_sub_bitmap(scrbuf,0,0,xm,ym);
    view[1]=create_sub_bitmap(scrbuf,xq,ym+1,xm,ym-1);
    view[2]=create_sub_bitmap(scrbuf,xm+1,0,xm-1,ym);
   }
   break;
  case 2:
   {
    int xm=gfx_w>>1;
    int ym=gfx_h>>1;
    int yq=(ym+1)>>1;
    view[0]=create_sub_bitmap(scrbuf,0,yq,xm,ym);
    view[1]=create_sub_bitmap(scrbuf,xm+1,yq,xm-1,ym);
   }
   break;
  default:
   view[0]=create_sub_bitmap(scrbuf,0,0,gfx_w,gfx_h);
 }
 {
  int n=0;
  int p;
  for (p=0;p<MAX_PLAYERS;p++) if (player_info[p].playing) {
   player_info[p].view=view[n];
   player_info[p].score_x=view[n]->w-(7<<3);
   player_info[p].score_y=
              (strlen(player_info[p].name)+1)<<3>player_info[p].score_x?10:0;
   n++;
  }
 }
}

void draw_views() {
 int p;
 for (p=0;p<MAX_PLAYERS;p++) if (player_info[p].playing) {
  BITMAP *bmp=player_info[p].view;
  float z_vp=level->player[p].z+Z_VP_RAISE;
  float st=sin(level->player[p].th);
  float ct=cos(level->player[p].th);

  draw_starfield(bmp,st,ct);

  sort_objects(bmp,level->player[p].x,level->player[p].y,z_vp,st,ct);
  if (z_vp>=0) {
   draw_objects_below_grid(bmp);
   draw_grid(bmp,level->player[p].x,level->player[p].y,z_vp,st,ct);
   draw_objects_above_grid(bmp);
  } else {
   draw_objects_above_grid(bmp);
   draw_grid(bmp,level->player[p].x,level->player[p].y,z_vp,st,ct);
   draw_objects_below_grid(bmp);
   {
    char *str1,*str2;
    if (end_game) {
     if (p==sheep_popper) {
      str1="NICELY";
      str2="SAVED";
     } else {
      str1="SAVED BY";
      str2="THE BELL";
     }
    } else {
     str1="WHOOPS!";
     str2="Lose 1000 points";
    }
    textout_centre(bmp,font,str1,bmp->w>>1,(bmp->h>>1)-8,makecol(255,255,0));
    textout_centre(bmp,font,str2,bmp->w>>1,bmp->h>>1,makecol(255,128,0));
   }
  }
  textprintf(bmp,font,0,0,MAKE_PLAYER_COLOUR(p),"%s",player_info[p].name);
  textprintf(bmp,font,player_info[p].score_x,player_info[p].score_y,
                           MAKE_PLAYER_COLOUR(p),"%7d",player_info[p].score);
 }

/*
 for (p=0;p<n_bubbles;p++) {
  textprintf(scrbuf,font,0,p*8,makecol(255,255,255),"(%.3f,%.3f,%.3f)",
  level->bubble[p].x,
  level->bubble[p].y,
  level->bubble[p].z);
 }
*/
}

void destroy_views() {
 int p;
 for (p=0;p<MAX_PLAYERS;p++) {
  if (player_info[p].playing) destroy_bitmap(player_info[p].view);
 }
}
