#include "sheep.h"

/*
 This module was taken from another of my projects and adapted.
*/

#define MAX_FRAME_SKIP 20

volatile int counter=0;
KEY_LIST key_queue[MAX_FRAME_SKIP][MAX_PLAYERS];
KEY_LIST *ckey=key_queue[0];
KEY_LIST *volatile nkey=key_queue[0];

void timer_handler() {
 int c=counter;
 if (c<MAX_FRAME_SKIP) {
  register KEY_LIST *k=nkey;
  {
   int p;
   for (p=0;p<MAX_PLAYERS;p++) if (player_info[p].playing) {
    k[p].l=key[player_info[p].k.l];
    k[p].r=key[player_info[p].k.r];
    k[p].u=key[player_info[p].k.u];
    k[p].d=key[player_info[p].k.d];
   }
  }
  k+=MAX_PLAYERS;
  if (k==key_queue[MAX_FRAME_SKIP]) k=key_queue[0];
  nkey=k;
  counter++;
 }
} END_OF_FUNCTION(timer_handler);

//advances the ckey pointer and decreases counter
void end_frame() {
 register KEY_LIST *k=ckey;
 k+=MAX_PLAYERS;
 if (k==key_queue[MAX_FRAME_SKIP]) k=key_queue[0];
 ckey=k;
 counter--;
}

void initialise_timing() {
 LOCK_VARIABLE(counter);
 LOCK_VARIABLE(key_queue);
 LOCK_VARIABLE(nkey);
 LOCK_VARIABLE(player_info);
 LOCK_FUNCTION(timer_handler);
}

void start_timing() {
 install_int_ex(timer_handler,TIMER_RATE);
}

void end_timing() {
 remove_int(timer_handler);
 counter=0;
 ckey=key_queue[0];
 nkey=key_queue[0];
}