#include "sheep.h"

void create_starfield() {
 {
  STAR *star=level->star;
  int s;
  for (s=0;s<n_stars;s++,star++) {
   float r,th;
   star->z=random()*(2.0/RAND_RANGE)-1.0;
   r=1-star->z*star->z;
   if (r>0) {
    r=sqrt(r);
    th=random()*(2.0*M_PI/RAND_RANGE);
    star->x=r*sin(th);
    star->y=r*cos(th);
   } else {
    star->x=0;
    star->y=0;
   }
   r=sqrt(random()*(1.0/RAND_RANGE));
   star->x*=r;
   star->y*=r;
   star->z*=r;
  }
 }

 {
  float r,th;
  level->star_zv=random()*(0.002/RAND_RANGE)-0.001;
  r=0.000001-level->star_zv*level->star_zv;
  if (r>0) {
   r=sqrt(r);
   th=random()*(2.0*M_PI/RAND_RANGE);
   level->star_xv=r*sin(th);
   level->star_yv=r*cos(th);
  } else {
   level->star_xv=0;
   level->star_yv=0;
  }
 }

 {
  float x,y,z;
  {
   float r,th;
   z=random()*(2.0/RAND_RANGE)-1.0;
   r=1-z*z;
   if (r>0) {
    r=sqrt(r);
    th=random()*(2.0*M_PI/RAND_RANGE);
    x=r*sin(th);
    y=r*cos(th);
   } else {
    x=0;
    y=0;
   }
  }
  get_vector_rotation_quat(&level->star_q,x,y,z,0.2);
 }
}

void update_starfield() {
 STAR *star=level->star;
 int s;
 MATRIX_f m;
 quat_to_matrix(&level->star_q,&m);
 for (s=0;s<n_stars;s++,star++) {
  apply_matrix_f(&m,star->x+level->star_xv,
                    star->y+level->star_yv,
                    star->z+level->star_zv,&star->x,&star->y,&star->z);
  {
   float r=star->x*star->x+star->y*star->y+star->z*star->z;
   if (r>1.0*1.0) {
    r=sqrt(r);
    star->x=-star->x/r;
    star->y=-star->y/r;
    star->z=-star->z/r;
   }
  }
 }
 apply_matrix_f(&m, level->star_xv, level->star_yv, level->star_zv,
                   &level->star_xv,&level->star_yv,&level->star_zv);

 //randomise velocity slightly, as well as quat?
}

void draw_starfield(BITMAP *bmp,float st,float ct) {
 int white=makecol(255,255,255);
 STAR *star=level->star;
 int s;
 for (s=0;s<n_stars;s++,star++) {
  float z=star->x*st-star->y*ct;
  if (z>=0.0001) {
   float x=((star->x*ct+star->y*st)/z+1.0)*(bmp->w>>1);
   float y=(0.5-star->z*(2.0/3.0)/z)*bmp->h;
   if (z<0.1) z=0.1;//limit size at which stars appear
   {
    float w=bmp->w*0.001/z;
    float h=(bmp->h*(4.0/3.0)*0.001)/z;
    if (x>=-w && x<=bmp->w+w && y>=-h && y<=bmp->h+h) {
     float mag=w*h;
     if (mag>1) {
      ellipsefill(bmp,x,y,w,h,white);
     } else {
      int c=255*mag;
      putpixel(bmp,x,y,makecol(c,64+191*mag,c));
     }
    }
   }
  }
 }
}
