#include "sheep.h"

//gets the volume and pan of a sample by summing copies of the
//sound from different players' views.
//Set loud==255.0*r*r for samples at full volume
//at a distance of r*3 grid squares.
void originate_sample(float x,float y,float z,float loud,int *vol,int *pan) {
 float tvol=0,rvol=0;
 {
  int p;
  for (p=0;p<MAX_PLAYERS;p++) if (player_info[p].playing) {
   float xr=x-level->player[p].x,
         yr=y-level->player[p].y,
         zr=z-level->player[p].z-Z_VP_RAISE;
   //set zr to distance squared
   zr=xr*xr+yr*yr+zr*zr;
   //set xr to pan, as horizontal component over radius
   //if radius is too small, revert to centre panning
   if (zr<0.01) {
    xr=0.5;
   } else {
    xr=0.5+(xr*cos(level->player[p].th)+yr*sin(level->player[p].th))/
                                                              (2.0*sqrt(zr));
   }
   //set zr to volume, according to inverse square law
   //the constant means samples at full volume up to distance 6
   //if zr is within 36 grid square, limit sound level
   if (zr<3.0) zr=loud; else zr=loud*(3.0*3.0)/zr;
   //0 <= xr <= 1
   //update tvol (total volume) and rvol (right volume)
   tvol+=zr;
   rvol+=zr*xr;
  }
 }
 if (tvol>=255) *vol=255; else *vol=tvol;
 *pan=255.0*rvol/tvol;
}
