#include <ctype.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "allegro.h"
#include "datafile.h"

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

#ifdef DJGPP
#define RAND_RANGE 0x7FFFFFFFl
#else
#define srandom(n) srand(n)
#define random() rand()
#define RAND_RANGE RAND_MAX
#define stpcpy(d,s) (strcpy(d,s)+strlen(s))
#endif

typedef enum {t_hole,t_floor,t_wall} TILE;

#define MAX_PLAYERS 4
#define MAX_BUBBLES 100

#define MAX_NAME_LENGTH 19//just happens to be a multiple of 4, minus 1 :-)

typedef enum {m_skip,m_normal,m_exit} SHEEP_MENU_TYPE;

typedef struct SHEEP_MENU {
 char *str1;//str1==0 indicates end of menu
 char *(*str2)(void);//function to return current option; can be NULL
 int colour;//index into player_colour array; but selected option is white
 SHEEP_MENU_TYPE t;
 int (*proc)(struct SHEEP_MENU *,int);//for processing keys
                                     //return 1 to redraw/exit depending on t
 void (*space)(struct SHEEP_MENU *);//special case for enter or space pressed
} SHEEP_MENU;

#define FILL_MENU(menu,p_str1,p_str2,p_colour,p_t,p_proc,p_space) \
 (menu)->str1=p_str1;                                             \
 (menu)->str2=p_str2;                                             \
 (menu)->colour=p_colour;                                         \
 (menu)->t=p_t;                                                   \
 (menu)->proc=p_proc;                                             \
 (menu)->space=p_space;

typedef struct MESSAGE {
 struct MESSAGE *next;
 BITMAP *bmp;
 int x,y,w,h;
} MESSAGE;

//doubles as scancode list and keys held list
typedef struct {
 unsigned char l,r,u,d;
} KEY_LIST;

typedef struct {
 int playing;
 char name[MAX_NAME_LENGTH+1];
 int colour;//index into player_colour[] array
 KEY_LIST k;
 BITMAP *view;//sub-bitmap of scrbuf, set up while playing
 int score_x,score_y;
 int score;
} PLAYER_INFO;

typedef struct {
 float x,y,z,th;//th is the angle - 0 means (0,-1), rotate clockwise, radians
 float xv,yv,zv,thv;
} PLAYER;

#define N_BUBBLE_TYPES 4

typedef struct {
 float x,y,z;
 float xv,yv,zv;
 int type;
 int score;
} BUBBLE;

typedef struct {
 float h,z;
 float hv,zv;
 int c;
 int time;
} POP_PIXEL;

#define N_POP_PIXELS 128
#define POP_PIXEL_SIZE 0.005
#define N_EXPLODE_PIXELS 256
#define EXPLODE_PIXEL_SIZE (1.5/16.0)
#define POP_START_SIZE 50
typedef struct POP {
 struct POP *next;
 float x,y,z;
 //no velocity; pops stay still
 int type;//what was in the bubble that produced this pop
 //sprite animation to be planned
 int size;//size goes from POP_START_SIZE to size_end before the sprite
          //explodes into more of those nice pixels
 int size_end;
 int external_pixels;
 POP_PIXEL pixel[N_EXPLODE_PIXELS];
} POP;

#define MAX_STARS 1000
typedef struct {
 float x,y,z;
} STAR;

typedef struct {
 int w,h;
 TILE **tile;
 PLAYER player[MAX_PLAYERS];
 int n_bubbles;
 BUBBLE bubble[MAX_BUBBLES];
 POP *pop;//linked list
 STAR star[MAX_STARS];
 float star_xv,star_yv,star_zv;
 QUAT star_q;
} LEVEL;

typedef struct {
 int score;
 char name[MAX_NAME_LENGTH+1];
 int colour;
} HISCORE;

#define N_HISCORES 10

//bubble.c
#define BUBBLE_SAMPLE_TIME 60
void initialise_bubble(BUBBLE *bubble);
void propagate_bubble(BUBBLE *bubble);
void draw_bubble(BITMAP *bmp,float x,float y,float z,float w,float h,int id);

//collide.c
void test_object_collision(float *x1, float *y1, float *z1,
                           float *x1v,float *y1v,float *z1v,
                           float *x2, float *y2, float *z2,
                           float *x2v,float *y2v,float *z2v);
void collide_with_walls(float *x,float *y,float z,float *xv,float *yv);
void collide_with_floors(float *x, float *y, float *z,
                         float *xv,float *yv,float *zv);

//drawobj.c
void sort_objects(BITMAP *bmp,float x,float y,float z,float st,float ct);
void draw_objects_below_grid(BITMAP *bmp);
void draw_objects_above_grid(BITMAP *bmp);

//editplay.c
extern int player_editing;
void do_edit_player(void);

//game.c
extern int n_players;
extern PLAYER_INFO player_info[MAX_PLAYERS];
extern LEVEL *level;
extern int game_time;
extern int end_game;
extern int sheep_popper;
extern int winner;
extern int winning_score;
extern int score_per_bubble;
void play_game(SHEEP_MENU *menu);

//grid.c
void initialise_grid(void);
void draw_grid(BITMAP *bmp,float x,float y,float z,float st,float ct);

//hiscore.c
void set_default_hiscores(void);
void load_hiscores(void);
void save_hiscores(void);
int record_scores(void);
void show_hiscore_table(int n);
void view_hiscores(SHEEP_MENU *menu);

//level.c
extern char level_filename[256];
LEVEL *load_level(char *filename);
void destroy_level(LEVEL *level);
char *get_level(void);

//levmenu.c
void change_level(SHEEP_MENU *menu);

//messages.c
extern MESSAGE *message;
void queue_message(char *str,int c);
void update_messages(void);
void end_messages(void);
void draw_messages(void);

//menu.c
#define MENU_LEADING 10
void draw_menu_message(char *str1,char *str2);
void menu_message(char *str1,char *str2);
void do_sheep_menu(SHEEP_MENU *menu,int option);

//options.c
extern int sheep_time;
#define MAX_SHEEP_TIME 10
#define REAL_SHEEP_TIME (sheep_time*(60*FRAMES_PER_SEC))
extern int sheep_number;
#define MAX_SHEEP_NUMBER 100
extern int n_stars;
void load_options(void);
void save_options(void);
void change_options(SHEEP_MENU *menu);

//optplay.c
void allocate_players(SHEEP_MENU *menu);

//player.c
void position_player(PLAYER *player);
void propagate_player(int p);
void draw_player(BITMAP *bmp,float x,float y,float z,float w,float h,int id);

//pop.c
void pop_all_bubbles(void);
void pop_bubble(BUBBLE *bubble);
void update_pops(void);
void draw_pop(BITMAP *bmp,float x,float y,float z,float hs,float zs,POP *id);

//sound.c
void originate_sample(float x,float y,float z,float loud,int *vol,int *pan);

//stars.c
void create_starfield(void);
void update_starfield(void);
void draw_starfield(BITMAP *bmp,float st,float ct);

//timing.c
#define FRAMES_PER_SEC 100
#define TIMER_RATE 11932
#define MAX_FRAME_SKIP 20
extern volatile int counter;
extern KEY_LIST *ckey;
void end_frame(void);
void initialise_timing(void);
void start_timing(void);
void end_timing(void);

//view.c
#define Z_VP_RAISE 0.2
void get_views(void);
void draw_views(void);
void destroy_views(void);

//winner.c
void process_winner(void);

//sheep.c
extern char tempstr[256];
#define N_PLAYER_COLOURS 9
extern RGB player_colour[N_PLAYER_COLOURS];
#define MAKE_PLAYER_COLOUR(p)                    \
 makecol(player_colour[player_info[p].colour].r, \
         player_colour[player_info[p].colour].g, \
         player_colour[player_info[p].colour].b)
extern DATAFILE *dat;
extern RGB_MAP the_rgb_map;
extern int gfx_w,gfx_h;
extern int gfx_depth;
extern int gfx_changed;
extern int gfxr_w,gfxr_h;
extern int gfxr_depth;
extern BITMAP *scrbuf;

//This will be out of view for objects up to 24*4/3 grid squares away
#define Z_OUT_OF_VIEW 24

#define SCRBUF_TO_SCREEN blit(scrbuf,screen,0,0,0,0,gfx_w,gfx_h);
