#include "sheep.h"

char tempstr[256];

RGB player_colour[N_PLAYER_COLOURS]={{255,0,0},
                                     {255,128,0},
                                     {255,255,0},
                                     {0,255,0},
                                     {0,255,128},
                                     {0,255,255},
                                     {0,128,255},
                                     {128,0,255},
                                     {255,0,192}};

DATAFILE *pal;
DATAFILE *dat;

RGB_MAP the_rgb_map;

int gfx_w,gfx_h;
int gfx_depth;
int gfx_changed=0;

//values to revert to
int gfxr_w=320,gfxr_h=200;
int gfxr_depth=8;

BITMAP *scrbuf;

SHEEP_MENU main_menu[]=
{{"Current level: " ,get_level,6,m_skip  ,0,0               },
 {""                ,0        ,0,m_skip  ,0,0               },
 {"Play Game"       ,0        ,1,m_normal,0,play_game       },
 {"Allocate Players",0        ,2,m_normal,0,allocate_players},
 {"Change Options"  ,0        ,3,m_normal,0,change_options  },
 {"View High Scores",0        ,4,m_normal,0,view_hiscores   },
 {"Change Level"    ,0        ,5,m_normal,0,change_level    },
 {""                ,0        ,0,m_skip  ,0,0               },
 {"Exit Game"       ,0        ,0,m_exit  ,0,0               },
 {0                 ,0        ,0,0       ,0,0               }};

int main() {
 srandom(time(0));
 allegro_init();
 install_timer();
 install_keyboard();
 initialise_timing();

 pal=load_datafile("palette.dat");
 if (pal==0) {
  allegro_message("Unable to load palette.dat\n");
  return 1;
 }

 set_config_file("sheep.ini");
 load_options();

 reserve_voices(64,-1);
 set_volume_per_voice(2);
 install_sound(DIGI_AUTODETECT,MIDI_NONE,0);

restart_graphics:

 set_color_depth(gfx_depth);
 if (set_gfx_mode(GFX_AUTODETECT,gfx_w,gfx_h,0,0)) {
  char first_error[256];
  strcpy(first_error,allegro_error);
  set_color_depth(gfxr_depth);
  if (set_gfx_mode(GFX_AUTODETECT,gfxr_w,gfxr_h,0,0)) {
   allegro_message("Error setting %dx%dx%d\n%s\n\n"
                   "Error reverting to %dx%dx%d\n%s\n\n",
                                      gfx_w, gfx_h, gfx_depth,first_error,
                                     gfxr_w,gfxr_h,gfxr_depth,allegro_error);
   return 1;
  }
  gfx_w=gfxr_w;
  gfx_h=gfxr_h;
  gfx_depth=gfxr_depth;
  gfx_changed=1;
 }

 if (gfx_depth==8) {
  set_palette(pal->dat);
  create_rgb_table(&the_rgb_map,pal->dat,0);
  the_rgb_map.data[31][0][31]=0;//to convert bright pink to zero in 8-bit
  rgb_map=&the_rgb_map;
 }

 dat=load_datafile("sheep.dat");
 if (dat==0) {
  set_gfx_mode(GFX_TEXT,0,0,0,0);
  allegro_message("Unable to load sheep.dat\n");
  return 1;
 }

 text_mode(-1);

 scrbuf=create_bitmap(gfx_w,gfx_h);

 load_hiscores();

 initialise_grid();

 if (gfx_changed) {
  sprintf(tempstr,"Reverted to %dx%dx%d.",gfx_w,gfx_h,gfx_depth);
  menu_message("Error setting graphics mode.",tempstr);
  gfx_changed=0;
 }

 gfxr_w=gfx_w;
 gfxr_h=gfx_h;
 gfxr_depth=gfx_depth;

 do_sheep_menu(main_menu,2);

 destroy_bitmap(scrbuf);
 unload_datafile(dat);
 save_options();

 if (gfx_changed) {
  gfx_changed=0;
  goto restart_graphics;
 }

 unload_datafile(pal);

 return 0;
} END_OF_MAIN();
