#include "sheep.h"

int end_pop_active;
POP_PIXEL end_pop_pixel[N_POP_PIXELS];

void pop_all_bubbles() {
 end_pop_active=1;
 {
  int white=makecol(255,255,255);
  //in end game, we use a single array of POP_PIXELs for all the bubbles
  //to cut down on processor power. This is only for the bubbles though;
  //when the images explode, they remain separate.
  POP_PIXEL *pixel=end_pop_pixel;
  int p;
  for (p=0;p<N_POP_PIXELS;p++,pixel++) {
   float r;
   pixel->z=random()*(2.0/RAND_RANGE)-1.0;
   r=1.0-pixel->z*pixel->z;
   if (r<=0) {
    pixel->h=0;
   } else {
    pixel->h=sqrt(r)*sin(random()*(2*M_PI/RAND_RANGE));
   }
   r=0.05+random()*(0.05/RAND_RANGE);
   pixel->hv=pixel->h*r;
   pixel->zv=pixel->z*r;
   pixel->c=white;
   pixel->time=16+(random()&31);
  }
 }

 {
  int b;
  for (b=0;b<level->n_bubbles;b++) {
   POP *pop=malloc(sizeof(POP));
   pop->x=level->bubble[b].x;
   pop->y=level->bubble[b].y;
   pop->z=level->bubble[b].z;
   pop->type=level->bubble[b].type;
   pop->size=POP_START_SIZE;
   //in the case of end game, the particles from different bubbles must not
   //all appear at the same time, in the interest of speed. So we have a
   //much wider range for how big the objects inflate and, hence, how long
   //before they explode.
   pop->size_end=(POP_START_SIZE+68)+(random()&511);
   pop->external_pixels=1;
   pop->next=level->pop;
   level->pop=pop;
  }
 }
}


void pop_bubble(BUBBLE *bubble) {
 POP *pop=malloc(sizeof(POP));
 pop->x=bubble->x;
 pop->y=bubble->y;
 pop->z=bubble->z;
 pop->type=bubble->type;
 pop->size=POP_START_SIZE;
 pop->size_end=(POP_START_SIZE+68)+(random()&63);
 pop->external_pixels=0;
 {
  int white=makecol(255,255,255);
  POP_PIXEL *pixel=pop->pixel;
  int p;
  for (p=0;p<N_POP_PIXELS;p++,pixel++) {
   float r;
   pixel->z=random()*(2.0/RAND_RANGE)-1.0;
   r=1.0-pixel->z*pixel->z;
   if (r<=0) {
    pixel->h=0;
   } else {
    pixel->h=sqrt(r)*sin(random()*(2*M_PI/RAND_RANGE));
   }
   r=0.05+random()*(0.05/RAND_RANGE);
   pixel->hv=pixel->h*r;
   pixel->zv=pixel->z*r;
   pixel->c=white;
   pixel->time=16+(random()&31);
  }
 }
 {
  int vol,pan;
  originate_sample(pop->x,pop->y,pop->z,1020.0,&vol,&pan);
  play_sample(dat[SFX0_POP].dat,vol,pan,1000,0);
 }
 pop->next=level->pop;
 level->pop=pop;
}

void update_pops() {
 if (end_game && end_pop_active) {
  POP_PIXEL *pixel=end_pop_pixel;
  int p;
  end_pop_active=0;
  for (p=0;p<N_POP_PIXELS;p++,pixel++) {
   if (pixel->time) {
    end_pop_active=1;
    pixel->h+=pixel->hv;
    pixel->zv-=0.001;
    pixel->z+=pixel->zv;
    pixel->time--;
   }
  }
 }

 {
  POP **pop_p=&level->pop;
  while (*pop_p) {
   POP *pop=*pop_p;
   pop->z+=0.02;
   if (pop->external_pixels==0) {
    int active=0;
    POP_PIXEL *pixel=pop->pixel;
    int p,p_end=pop->size?N_POP_PIXELS:N_EXPLODE_PIXELS;
    for (p=0;p<p_end;p++,pixel++) {
     if (pixel->time) {
      active=1;
      pixel->h+=pixel->hv;
      pixel->zv-=0.001;
      pixel->z+=pixel->zv;
      pixel->time--;
     }
    }
    if (active==0 && pop->size==0) {
     *pop_p=pop->next;
     free(pop);
     continue;
    }
   }
   if (pop->size) {
    pop->size++;
    if (pop->size==pop->size_end) {
     pop->size=0;
     pop->external_pixels=0;
     {
      BITMAP *sprite=dat[BUBBLE000+pop->type].dat;
      int mask=bitmap_mask_color(sprite);
      POP_PIXEL *pixel=pop->pixel;
      int p;
      for (p=0;p<N_EXPLODE_PIXELS;p++,pixel++) {
       float x=random()*(1.0/RAND_RANGE);
       float y=random()*(1.0/RAND_RANGE);
       int c=getpixel(sprite,floor(x*sprite->w),floor(y*sprite->h));
       if (c!=-1 && c!=mask) {
        pixel->c=c;
        pixel->h=(x-0.5)*(pop->size_end/(POP_START_SIZE/2.0));
        pixel->z=(0.5-y)*(pop->size_end/(POP_START_SIZE/2.0));
        {
         float r=0.05+random()*(0.05/RAND_RANGE);
         pixel->hv=pixel->h*r;
         pixel->zv=pixel->z*r;
        }
        pixel->time=32+(random()&63);
       } else {
        pixel->time=0;
       }
      }
     }
     {
      int vol,pan;
      originate_sample(pop->x,pop->y,pop->z,4080.0,&vol,&pan);
      play_sample(dat[SFX2_EXPLODE].dat,vol,pan,1000,0);
     }
    } else if (pop->size==pop->size_end-BUBBLE_SAMPLE_TIME) {
     {
      int vol,pan;
      originate_sample(pop->x,pop->y,pop->z,4080.0,&vol,&pan);
      play_sample(dat[SFX1_INFLATE].dat,vol>>2,pan,1000,0);
      play_sample(dat[SAMPLE000+pop->type].dat,vol,pan,881+(random()&255),0);
     }
    }
   }
   pop_p=&pop->next;
  }
 }
}

void draw_pop(BITMAP *bmp,float x,float y,float z,float hs,float zs,POP *id) {

 if (id->size) {
  float s=id->size/(float)POP_START_SIZE;
  float w=hs*s;
  float h=zs*s;
  if (x>=-w && x<=bmp->w+w && y>=-h && y<=bmp->h+h) {
   stretch_sprite(bmp,dat[BUBBLE000+id->type].dat,x-w,y-h,w*2,h*2);
  }
 }

#define SAFE 4096

 //draw the pixels (in fact draw them as lines to create motion blur)
 if (id->external_pixels==0 || end_pop_active) {
  POP_PIXEL *pixel=id->external_pixels?end_pop_pixel:id->pixel;
  int p;
  int n_pixels=(id->size?N_POP_PIXELS:N_EXPLODE_PIXELS);
  float xs=(id->size?POP_PIXEL_SIZE:EXPLODE_PIXEL_SIZE)*bmp->w/z;
  float ys=(id->size?POP_PIXEL_SIZE*4.0/3.0:EXPLODE_PIXEL_SIZE*4.0/3.0)*bmp->h/z;
  int p_end=n_pixels*xs*ys;//vary number of particles with z
  if (p_end>n_pixels) {
   for (p=0;p<n_pixels;p++,pixel++) {
    if (pixel->time) {
     float x1=x+(pixel->h-pixel->hv)*hs;
     float y1=y-(pixel->z-pixel->zv)*zs;
     float x2=x+pixel->h*hs;
     float y2=y-pixel->z*zs;
     if (x1>=-SAFE && x1<SAFE && y1>=-SAFE && y1<SAFE &&
         x2>=-SAFE && x2<SAFE && y2>=-SAFE && y2<SAFE) {
      float xf=x2-x1;
      float yf=y2-y1;
      float xr,yr;
      {
       float r=xf*xf+yf*yf;
       if (r<0.000001) {
        xf=1;
        yf=0;
       } else {
        r=sqrt(r);
        xf/=r;
        yf/=r;
       }
      }
      xr=-yf*xs;
      yr=xf*ys;
      xf*=xs;
      yf*=ys;

      {
       int p[8]={x1-xf,y1-yf,x2-xr,y2-yr,x2+xf,y2+yf,x2+xr,y2+yr};
       polygon(bmp,4,p,pixel->c);
      }
     }
    }
   }
  } else {
   for (p=0;p<p_end;p++,pixel++) {
    if (pixel->time) {
     float x1=x+(pixel->h-pixel->hv)*hs;
     float y1=y-(pixel->z-pixel->zv)*zs;
     float x2=x+pixel->h*hs;
     float y2=y-pixel->z*zs;
     if (x1>=-SAFE && x1<SAFE && y1>=-SAFE && y1<SAFE &&
         x2>=-SAFE && x2<SAFE && y2>=-SAFE && y2<SAFE) {
      line(bmp,floor(x1),floor(y1),floor(x2),floor(y2),pixel->c);
     }
    }
   }
  }
 }
}
