#include "sheep.h"

//This could be improved given more time
void position_player(PLAYER *player) {
 //choose random position out of those covered by floors
 {
  int n=0;
  {
   int y;
   for (y=1;y<level->h;y++) {
    int x;
    for (x=1;x<level->w;x++) {
     if (level->tile[y-1][x-1]==t_floor && level->tile[y-1][x  ]==t_floor &&
         level->tile[y  ][x-1]==t_floor && level->tile[y  ][x  ]==t_floor) {
      n++;
      if (random()%n==0) {
       player->x=x;
       player->y=y;
      }
     }
    }
   }
  }
  //if no positions were found, initialise randomly
  if (n==0) {
   player->x=((float)random()/RAND_RANGE)*level->w;
   player->y=((float)random()/RAND_RANGE)*level->h;
  }
 }

 //choose random direction
 player->th=random()*(2*M_PI/RAND_RANGE);

 //initialise velocities to 0
 player->xv=0;
 player->yv=0;
 player->thv=0;
}

void propagate_player(int p) {
 PLAYER *player=&level->player[p];
 KEY_LIST *k=&ckey[p];

 //angular
 if (k->l && k->r==0) player->thv-=M_PI/2500.0;
 if (k->r && k->l==0) player->thv+=M_PI/2500.0;
 player->thv*=0.98;
 player->th+=player->thv;
 while (player->th>=2*M_PI) player->th-=2*M_PI;
 while (player->th<0) player->th+=2*M_PI;

 //linear
 if (k->u && k->d==0) {
  player->xv+=sin(player->th)/500.0;
  player->yv-=cos(player->th)/500.0;
 }
 if (k->d && k->u==0) {
  player->xv-=sin(player->th)/500.0;
  player->yv+=cos(player->th)/500.0;
 }
 player->xv*=0.98;
 player->yv*=0.98;
 player->x+=player->xv;
 player->y+=player->yv;

 //test if player is over a hole
 if (player->z>=0) {
  int x=floor(player->x);
  int y=floor(player->y);
  if (x>=0 && x<level->w && y>=0 && y<level->h && level->tile[y][x]!=t_hole) {
   //hover
   if (player->zv<0) {
    if (player->z<1.19) player->zv+=0.001; else player->zv-=0.001;
   } else {
    if (player->z>1.21) player->zv-=0.001; else player->zv+=0.001;
   }
   goto hovered;//avoids 2 'else' clauses
  }
 }
 player->zv-=0.001;

hovered:

 player->zv*=0.99;
 player->z+=player->zv;

 if (player->z>=0) {
  //test for collisions with walls
  collide_with_walls(&player->x ,&player->y, player->z,
                     &player->xv,&player->yv);
  if (player->z<1.0) {
   collide_with_floors(&player->x ,&player->y ,&player->z,
                       &player->xv,&player->yv,&player->zv);
  }
 } else if (player->z<-Z_OUT_OF_VIEW) {
  player_info[p].score-=1000;
  //reposition player at top
  player->z=Z_OUT_OF_VIEW;
  player->zv=0;
  position_player(player);
 }
}

void draw_player(BITMAP *bmp,float x,float y,float z,float w,float h,int id) {
 ellipsefill(bmp,x,y,w,h,MAKE_PLAYER_COLOUR(id));
}
