#include "sheep.h"

#define PM_PLAYER 4

#define STR_PLAYER(p)                                              \
char *str_player##p() {                                            \
 {                                                                 \
  int n;                                                           \
  for (n=0;n<MAX_NAME_LENGTH;n++) tempstr[n]=' ';                  \
  tempstr[n]=0;                                                    \
 }                                                                 \
 if (player_info[p].playing)                                       \
  memcpy(tempstr,player_info[p].name,strlen(player_info[p].name)); \
 return tempstr;                                                   \
}

STR_PLAYER(0)
STR_PLAYER(1)
STR_PLAYER(2)
STR_PLAYER(3)

SHEEP_MENU players_menu[];

int change_player(SHEEP_MENU *menu,int k) {
 int p=menu-&players_menu[PM_PLAYER];
 switch (k>>8) {
  case KEY_LEFT:
  case KEY_4_PAD:
  case KEY_RIGHT:
  case KEY_6_PAD:
   if (player_info[p].playing) {
    player_info[p].playing=0;
   } else {
    player_info[p].playing=1;
    if (player_info[p].name[0]==0) strcpy(player_info[p].name,"Anonymous");
   }
   return 1;
 }
 return 0;
}

void edit_player(SHEEP_MENU *menu) {
 player_editing=menu-&players_menu[PM_PLAYER];
 player_info[player_editing].playing=1;
 if (strcmp(player_info[player_editing].name,"Anonymous")==0)
  player_info[player_editing].name[0]=0;
 do_edit_player();
 if (player_info[player_editing].name[0]==0)
  strcpy(player_info[player_editing].name,"Anonymous");
 menu->colour=player_info[player_editing].colour;
}

SHEEP_MENU players_menu[]=
{{"Players"          ,0              ,2,m_skip  ,0            ,0          },
 {""                 ,0              ,0,m_skip  ,0            ,0          },
 {"Press Enter or Space to edit.",0  ,3,m_skip  ,0            ,0          },
 {""                 ,0              ,0,m_skip  ,0            ,0          },
 {"1. "              ,str_player0    ,0,m_normal,change_player,edit_player},
 {"2. "              ,str_player1    ,0,m_normal,change_player,edit_player},
 {"3. "              ,str_player2    ,0,m_normal,change_player,edit_player},
 {"4. "              ,str_player3    ,0,m_normal,change_player,edit_player},
 {""                 ,0              ,0,m_skip  ,0            ,0          },
 {"Accept Players"   ,0              ,5,m_exit  ,0            ,0          },
 {0                  ,0              ,0,0       ,0            ,0          }};

void allocate_players(SHEEP_MENU *menu) {
 players_menu[PM_PLAYER+0].colour=player_info[0].colour;
 players_menu[PM_PLAYER+1].colour=player_info[1].colour;
 players_menu[PM_PLAYER+2].colour=player_info[2].colour;
 players_menu[PM_PLAYER+3].colour=player_info[3].colour;
 do_sheep_menu(players_menu,4);
}