#include "sheep.h"

int sheep_time;
int sheep_number;
int n_stars;

typedef struct {
 int w,h;
} GFX_RES;

#define N_GFX_RES 11
GFX_RES gfx_res[N_GFX_RES+1]={{320,200},{320,240},{320,400},
                              {400,300},{400,600},
                              {640,400},{640,480},{800,600},
                              {1024,768},{1280,1024},{1600,1200}};
                    //room for an extra mode in case non-standard mode is set

int gfx_id;
int max_gfx_id;

void load_options() {
 gfx_w=get_config_int("graphics","gfx_w",320);
 gfx_h=get_config_int("graphics","gfx_h",200);
 if (gfx_w<320 || gfx_h<200) {
  gfx_w=320;
  gfx_h=200;
  gfx_changed=1;
 }

 gfx_depth=get_config_int("graphics","gfx_depth",8);
 if (gfx_depth!=15 && gfx_depth!=16 && gfx_depth!=24 && gfx_depth!=32)
                                                                 gfx_depth=8;

 strncpy(level_filename,get_config_string("game","level","plain"),255);
 sheep_time=get_config_int("game","sheep_time",3);
 if (sheep_time>MAX_SHEEP_TIME) sheep_time=MAX_SHEEP_TIME;
 else if (sheep_time<0) sheep_time=0;

 sheep_number=get_config_int("game","sheep_number",10);
 if (sheep_number>MAX_SHEEP_NUMBER) sheep_number=MAX_SHEEP_NUMBER;
 else if (sheep_number<1) sheep_number=1;
 else if (sheep_number>10) sheep_number-=sheep_number%5;

 n_stars=get_config_int("game","n_stars",1000);
 if (n_stars>MAX_STARS) n_stars=MAX_STARS;
 else if (n_stars<0) n_stars=0;
 else n_stars-=n_stars%100;

 {
  int p;
  for (p=0;p<MAX_PLAYERS;p++) {
   sprintf(tempstr,"player%c",'1'+p);
   player_info[p].playing=get_config_int(tempstr,"playing",0);
   strncpy(player_info[p].name,
          get_config_string(tempstr,"name",""),MAX_NAME_LENGTH);
   player_info[p].colour=get_config_int(tempstr,"colour",0);
   {
    int q;
restart_clash:
    for (q=0;q<p;q++) {
     if (player_info[p].colour==player_info[q].colour) {
      player_info[p].colour=(player_info[p].colour+1)%N_PLAYER_COLOURS;
      goto restart_clash;
     }
    }
   }
   player_info[p].k.l=get_config_int(tempstr,"key_l",0);
   player_info[p].k.r=get_config_int(tempstr,"key_r",0);
   player_info[p].k.u=get_config_int(tempstr,"key_u",0);
   player_info[p].k.d=get_config_int(tempstr,"key_d",0);
  }
 }
}

void save_options() {
 set_config_int("graphics","gfx_w",gfx_w);
 set_config_int("graphics","gfx_h",gfx_h);
 set_config_int("graphics","gfx_depth",gfx_depth);

 set_config_string("game","level",level_filename);

 set_config_int("game","sheep_time",sheep_time);
 set_config_int("game","sheep_number",sheep_number);
 set_config_int("game","n_stars",n_stars);

 {
  int p;
  for (p=0;p<MAX_PLAYERS;p++) {
   sprintf(tempstr,"player%c",'1'+p);
   set_config_int(tempstr,"playing",player_info[p].playing);
   set_config_string(tempstr,"name",player_info[p].name);
   set_config_int(tempstr,"colour",player_info[p].colour);
   set_config_int(tempstr,"key_l",player_info[p].k.l);
   set_config_int(tempstr,"key_r",player_info[p].k.r);
   set_config_int(tempstr,"key_u",player_info[p].k.u);
   set_config_int(tempstr,"key_d",player_info[p].k.d);
  }
 }
}

char *str_sheep_time() {
 if (sheep_time==0) return "immediate";
 sprintf(tempstr,"%2d:00    ",sheep_time);
 return tempstr;
}

char *str_sheep_number() {
#if MAX_SHEEP_NUMBER != 100
#error The string here must be changed
#endif
 sprintf(tempstr,"%3d/100  ",sheep_number);
 return tempstr;
}

char *str_n_stars() {
 if (n_stars==0) return "off      ";
 sprintf(tempstr,"%4d     ",n_stars);
 return tempstr;
}

char *str_gfx_res() {
 sprintf(tempstr,"%dx%d",gfx_res[gfx_id].w,gfx_res[gfx_id].h);
 {
  int l=strlen(tempstr);
  while (l<9) tempstr[l++]=' ';
 }
 tempstr[9]=0;
 return tempstr;
}

char *str_gfx_depth() {
 sprintf(tempstr,"%2d bpp   ",gfx_depth);
 return tempstr;
}

int change_sheep_time(SHEEP_MENU *menu,int k) {
 switch (k>>8) {
  case KEY_LEFT:
  case KEY_4_PAD:
   if (sheep_time>0) {
    sheep_time--;
    return 1;
   }
   break;
  case KEY_RIGHT:
  case KEY_6_PAD:
   if (sheep_time<MAX_SHEEP_TIME) {
    sheep_time++;
    return 1;
   }
 }
 return 0;
}

int change_sheep_number(SHEEP_MENU *menu,int k) {
 switch (k>>8) {
  case KEY_LEFT:
  case KEY_4_PAD:
   if (sheep_number>1) {
    if (sheep_number>10) sheep_number-=5; else sheep_number--;
    return 1;
   }
   break;
  case KEY_RIGHT:
  case KEY_6_PAD:
   if (sheep_number<MAX_SHEEP_NUMBER) {
    if (sheep_number>=10) sheep_number+=5; else sheep_number++;
    return 1;
   }
 }
 return 0;
}

int change_n_stars(SHEEP_MENU *menu,int k) {
 switch (k>>8) {
  case KEY_LEFT:
  case KEY_4_PAD:
   if (n_stars>0) {
    n_stars-=100;
    return 1;
   }
   break;
  case KEY_RIGHT:
  case KEY_6_PAD:
   if (n_stars<MAX_STARS) {
    n_stars+=100;
    return 1;
   }
 }
 return 0;
}

int change_gfx_res(SHEEP_MENU *menu,int k) {
 switch (k>>8) {
  case KEY_LEFT:
  case KEY_4_PAD:
   if (gfx_id==0) gfx_id=max_gfx_id;
   gfx_id--;
   return 1;
  case KEY_RIGHT:
  case KEY_6_PAD:
   gfx_id++;
   if (gfx_id==max_gfx_id) gfx_id=0;
   return 1;
 }
 return 0;
}

int change_gfx_depth(SHEEP_MENU *menu,int k) {
 switch (k>>8) {
  case KEY_LEFT:
  case KEY_4_PAD:
   switch (gfx_depth) {
    case 15: gfx_depth= 8; return 1;
    case 16: gfx_depth=15; return 1;
    case 24: gfx_depth=16; return 1;
    case 32: gfx_depth=24; return 1;
   }
   break;
  case KEY_RIGHT:
  case KEY_6_PAD:
   switch (gfx_depth) {
    case  8: gfx_depth=15; return 1;
    case 15: gfx_depth=16; return 1;
    case 16: gfx_depth=24; return 1;
    case 24: gfx_depth=32; return 1;
   }
 }
 return 0;
}

SHEEP_MENU options_menu[]=
{{"Options"          ,0               ,2,m_skip  ,0                  ,0},
 {""                 ,0               ,0,m_skip  ,0                  ,0},
 {"     Sheep Time: ",str_sheep_time  ,6,m_normal,change_sheep_time  ,0},
 {"Number of Sheep: ",str_sheep_number,7,m_normal,change_sheep_number,0},
 {"Number of Stars: ",str_n_stars     ,8,m_normal,change_n_stars     ,0},
 {""                 ,0               ,0,m_skip  ,0                  ,0},
 {"     Resolution: ",str_gfx_res     ,0,m_normal,change_gfx_res     ,0},
 {"   Colour Depth: ",str_gfx_depth   ,1,m_normal,change_gfx_depth   ,0},
 {""                 ,0               ,0,m_skip  ,0                  ,0},
 {"Accept Options"   ,0               ,5,m_exit  ,0                  ,0},
 {0                  ,0               ,0,0       ,0                  ,0}};

void change_options(SHEEP_MENU *menu) {
 int id;
 max_gfx_id=N_GFX_RES;
 for (id=0;id<N_GFX_RES;id++) {
  if (gfx_w==gfx_res[id].w && gfx_h==gfx_res[id].h) goto standard_gfx_res;
 }
 gfx_res[N_GFX_RES].w=gfx_w;
 gfx_res[N_GFX_RES].h=gfx_h;
 max_gfx_id++;
standard_gfx_res:
 gfx_id=id;
 do_sheep_menu(options_menu,2);
 if (gfx_id!=id) {
  gfx_changed=1;
  gfx_w=gfx_res[gfx_id].w;
  gfx_h=gfx_res[gfx_id].h;
 } else if (gfx_depth!=gfxr_depth) {
  gfx_changed=1;
 }
}
