#include "sheep.h"

void draw_menu_message(char *str1,char *str2) {
 int white=makecol(255,255,255);
 int green=makecol(0,255,0);
 int x=gfx_w>>1;
 int y=(gfx_h-20)>>1;
 clear(scrbuf);
 textout_centre(scrbuf,font,str1,x,y,white);
 y+=10;
 textout_centre(scrbuf,font,str2,x,y,green);
 SCRBUF_TO_SCREEN
}

void menu_message(char *str1,char *str2) {
 draw_menu_message(str1,str2);
 readkey();
}

void draw_sheep_menu(SHEEP_MENU *menu,int option,int x,int y) {
 int o;
 clear(scrbuf);
 for (o=0;menu->str1;o++,menu++,y+=10) {
  static char str[256];//has to be separate from tempstr
  char *p=stpcpy(str,menu->str1);
  if (menu->str2) strcpy(p,menu->str2());
  textout_centre(scrbuf,font,str,x,y,o==option?makecol(255,255,255):
                (menu->t==m_skip?makecol(player_colour[menu->colour].r,
                                         player_colour[menu->colour].g,
                                         player_colour[menu->colour].b):
                                 makecol(player_colour[menu->colour].r>>1,
                                         player_colour[menu->colour].g>>1,
                                         player_colour[menu->colour].b>>1)));
 }
 SCRBUF_TO_SCREEN
}

void do_sheep_menu(SHEEP_MENU *menu,int option) {
 int n_options=0;
 int x,yt;

 while (menu[n_options].str1) n_options++;

 x=gfx_w>>1;
 yt=(gfx_h-n_options*MENU_LEADING)>>1;

 //if option==n_options, this menu has no selectable options

 draw_sheep_menu(menu,option,x,yt);
 for (;;) {
  int k=readkey();
  int ks=k>>8;
  switch (ks) {
   case KEY_UP:
    if (option!=n_options) {
     do {
      if (option==0) option=n_options;
      option--;
     } while (menu[option].t==m_skip);
     draw_sheep_menu(menu,option,x,yt);
    }
    break;
   case KEY_DOWN:
    if (option!=n_options) {
     do {
      option++;
      if (option==n_options) option=0;
     } while (menu[option].t==m_skip);
     draw_sheep_menu(menu,option,x,yt);
    }
    break;
   case KEY_ENTER:
   case KEY_SPACE:
    if (menu[option].space) {
     menu[option].space(&menu[option]);
     if (gfx_changed) return;
     draw_sheep_menu(menu,option,x,yt);
     break;
    }
    if (menu[option].t==m_exit && menu[option].proc==0) return;
    //fall through
   default:
    if (menu[option].proc && menu[option].proc(&menu[option],k)) {
     if (menu[option].t==m_exit) return;
     draw_sheep_menu(menu,option,x,yt);
    }
    if (ks==KEY_ESC) return;
  }
 }
}
