#include "sheep.h"

SHEEP_MENU *level_menu;

char *get_level() {
 return level_filename;
}

typedef struct {
 char name[256];
} LISTED_LEVEL;

int n_listed_levels;
int max_listed_levels;
LISTED_LEVEL *listed_level;
int level_page;
int level_selected;

#define N_LEVELS_PER_PAGE 16

void list_level(const char *filename, int attrib, int param) {
 if (n_listed_levels==max_listed_levels) {
  max_listed_levels+=N_LEVELS_PER_PAGE;
  listed_level=realloc(listed_level,sizeof(LISTED_LEVEL)*max_listed_levels);
 }

 {
  int p=strchr(filename,'.')-filename;
  strncpy(listed_level[n_listed_levels].name,filename,p);
  listed_level[n_listed_levels].name[p]=0;
 }

 n_listed_levels++;
}

int menu_level_proc(SHEEP_MENU *menu,int k) {
 switch (k>>8) {
  case KEY_LEFT:
  case KEY_4_PAD:
   //previous page
   if (level_page>0) {
    level_page-=N_LEVELS_PER_PAGE;
    level_selected=menu-level_menu;
    return 1;
   }
   break;
  case KEY_RIGHT:
  case KEY_6_PAD:
   //next page
   {
    int p=level_page+N_LEVELS_PER_PAGE;
    if (p<n_listed_levels) {
     level_page=p;
     level_selected=menu-level_menu;
     return 1;
    }
   }
   break;
  case KEY_SPACE:
  case KEY_ENTER:
   //select this level
   strcpy(level_filename,menu->str1);
   //fall through
  case KEY_ESC:
   level_page=-1;
   return 1;
 }
 return 0;//don't exit the menu
}

void create_level_menu() {
 int n=n_listed_levels-level_page;
 int r;
 if (n>N_LEVELS_PER_PAGE) n=N_LEVELS_PER_PAGE;
 if (n_listed_levels>N_LEVELS_PER_PAGE) r=N_LEVELS_PER_PAGE; else r=n;

 if (level_selected>n+1) level_selected=n+1;

 level_menu=malloc(sizeof(SHEEP_MENU)*(r+5));
 {
  SHEEP_MENU *menu=level_menu;

  FILL_MENU(menu,"Change Level",0,2,m_skip,0,0) menu++;
  FILL_MENU(menu,""            ,0,0,m_skip,0,0) menu++;
  {
   int l;
   for (l=0;l<n;l++,menu++) {
    FILL_MENU(menu,listed_level[level_page+l].name,0,l%N_PLAYER_COLOURS,
                                                    m_exit,menu_level_proc,0)
   }
   for (;l<r;l++,menu++) {
    FILL_MENU(menu,"",0,0,m_skip,0,0)
   }
  }

  if (n_listed_levels>N_LEVELS_PER_PAGE) {
   FILL_MENU(menu,"",0,0,m_skip,0,0) menu++;
   FILL_MENU(menu,"Use Left and Right Arrows to see more",0,5,m_skip,0,0) menu++;
  }
  FILL_MENU(menu,0,0,0,0,0,0)
 }
}

void change_level(SHEEP_MENU *menu) {
 //get a list of levels
 n_listed_levels=0;
 max_listed_levels=0;
 listed_level=0;
 for_each_file("*.lvl",0,list_level,0);

 if (n_listed_levels==0) {
  menu_message("No levels on disk!","Please reinstall.");
  return;
 }

 qsort(listed_level,n_listed_levels,sizeof(LISTED_LEVEL),
                                (int (*)(const void *,const void *))stricmp);

 for (level_selected=n_listed_levels;level_selected>0;) {
  level_selected--;
  if (strcmp(listed_level[level_selected].name,level_filename)==0) break;
 }

 level_page=level_selected/N_LEVELS_PER_PAGE;
 level_selected=level_selected-level_page*N_LEVELS_PER_PAGE+2;

 do {
  create_level_menu();
  do_sheep_menu(level_menu,level_selected);
  free(level_menu);
 } while (level_page>=0);
}
