#include "sheep.h"

HISCORE def_hiscore[N_HISCORES]={
 {10000,"Ben Davis",8},
 { 9000,"presents",8},
 { 8000,"Smoke-R-Scoff",2},
 { 7000,"blending the",6},
 { 6000,"addictiveness of",6},
 { 5000,"nicotine with",6},
 { 4000,"the bad health",6},
 { 3000,"of tobacco.",6},
 { 2000,"Best smoked while",1},
 { 1000,"drinking alcohol.",1}};

HISCORE hiscore[N_HISCORES];

void set_default_hiscores() {
 memcpy(hiscore,def_hiscore,sizeof(HISCORE)*N_HISCORES);
}

void load_hiscores() {
 PACKFILE *f;

 {
  char *p=strchr(level_filename,0);
  strcpy(p,".hsc");
  f=pack_fopen(level_filename,F_READ_PACKED);
  *p=0;
 }

 if (f==0) {
  set_default_hiscores();
  return;
 }
 {
  int p;
  for (p=0;p<N_HISCORES;p++) pack_fread(&hiscore[p],sizeof(HISCORE),f);
 }
 pack_fclose(f);
}

void save_hiscores() {
 PACKFILE *f;

 {
  char *p=strchr(level_filename,0);
  strcpy(p,".hsc");
  f=pack_fopen(level_filename,F_WRITE_PACKED);
  *p=0;
 }

 if (f==0) return;
 {
  int p;
  for (p=0;p<N_HISCORES;p++) pack_fwrite(&hiscore[p],sizeof(HISCORE),f);
 }
 pack_fclose(f);
}

int record_scores() {
#if N_HISCORES != 10
#error Change the following initialisation
#endif
 int ch[N_HISCORES]={0,0,0,0,0,0,0,0,0,0};
 {
  int p;
  for (p=0;p<MAX_PLAYERS;p++) if (winner&(1<<p)) {
   if (winning_score>=hiscore[N_HISCORES-1].score) {
    int pos=N_HISCORES-1;
    while (pos && winning_score>hiscore[pos-1].score) {
     hiscore[pos]=hiscore[pos-1];
     ch[pos]=ch[pos-1];
     pos--;
    }
    hiscore[pos].score=winning_score;
    strcpy(hiscore[pos].name,player_info[p].name);
    hiscore[pos].colour=player_info[p].colour;
    ch[pos]=1;
   }
  }
 }
 {
  int n=0;
  int pos;
  for (pos=N_HISCORES;pos>0;) {
   pos--;
   n<<=1;
   if (ch[pos]) n|=1;
  }
  return n;
 }
}

#define HISCORE_WIDTH (96+MAX_NAME_LENGTH*8)
#define HISCORE_HEIGHT (MENU_LEADING*(N_HISCORES+5))
void show_hiscore_table(int n) {
 clear(scrbuf);
 {
  int white=makecol(255,255,255);
  int tirq=makecol(0,255,128);
  int green=makecol(0,255,0);
  int p;
  int x=(gfx_w-HISCORE_WIDTH)>>1;
  int y=(gfx_h-HISCORE_HEIGHT)>>1;

  textprintf_centre(scrbuf,font,gfx_w>>1,y,white,"Current level: %s",
                                                             level_filename);
  y+=2*MENU_LEADING;

  for (p=0;p<N_HISCORES;p++,y+=MENU_LEADING) {
   textprintf(scrbuf,font,x,y,(n&1)?white:tirq,"%2d.",p+1);
   textprintf(scrbuf,font,x+32,y,(n&1)?white:green,"%7d",hiscore[p].score);
   textout(scrbuf,font,hiscore[p].name,x+96,y,
                                makecol(player_colour[hiscore[p].colour].r,
                                        player_colour[hiscore[p].colour].g,
                                        player_colour[hiscore[p].colour].b));
   n>>=1;
  }
  x=gfx_w>>1;
  y+=MENU_LEADING;
  textout_centre(scrbuf,font,"Type \"RESET\" to reset scores",x,y,green);
  y+=MENU_LEADING;
  textout_centre(scrbuf,font,"Press Enter or Space to return",x,y,white);
 }
 SCRBUF_TO_SCREEN
 {
  char str[5]="     ";
  for (;;) {
   int k=readkey();
   {
    register int ks=k>>8;
    if (ks==KEY_SPACE || ks==KEY_ENTER || ks==KEY_ESC) break;
   }
   str[0]=str[1];
   str[1]=str[2];
   str[2]=str[3];
   str[3]=str[4];
   str[4]=toupper(k&0xFF);
   if (strncmp(str,"RESET",5)==0) {
    set_default_hiscores();
    {
     char *p=strchr(level_filename,0);
     strcpy(p,".hsc");
     delete_file(level_filename);
     *p=0;
    }
    menu_message("Scores have been reset.","Press any key...");
    break;
   }
  }
 }
}

void view_hiscores(SHEEP_MENU *menu) {
 load_hiscores();
 show_hiscore_table(0);
}
