#include "sheep.h"

#define GRID_SQUARE_SIZE 64
#define GRID_SQUARE_SHIFT 6

#define GRID_INDENT 8

int grid_col[GRID_INDENT+1];
int grid_square[2][GRID_SQUARE_SIZE][GRID_SQUARE_SIZE];

void initialise_grid() {
 {
  int c,l;
  for (c=0,l=0;c<GRID_INDENT;c++,l+=256/GRID_INDENT) grid_col[c]=makecol(0,l,0);
  grid_col[c]=makecol(0,255,0);
 }

 {
  int y;
  for (y=0;y<GRID_INDENT;y++) {
   int x;
   for (x=0;x<y;x++) {
    grid_square[0][y][x]=GRID_INDENT-x;
    grid_square[1][y][x]=x;
   }
   for (;x<GRID_SQUARE_SIZE-y;x++) {
    grid_square[0][y][x]=GRID_INDENT-y;
    grid_square[1][y][x]=y;
   }
   for (;x<GRID_SQUARE_SIZE;x++) {
    grid_square[0][y][x]=x+(1+GRID_INDENT-GRID_SQUARE_SIZE);
    grid_square[1][y][x]=GRID_SQUARE_SIZE-1-x;
   }
  }
  for (;y<GRID_SQUARE_SIZE-GRID_INDENT;y++) {
   int x;
   for (x=0;x<GRID_INDENT;x++) {
    grid_square[0][y][x]=GRID_INDENT-x;
    grid_square[1][y][x]=x;
   }
   for (;x<GRID_SQUARE_SIZE-GRID_INDENT;x++) {
    grid_square[0][y][x]=0;
    grid_square[1][y][x]=GRID_INDENT;
   }
   for (;x<GRID_SQUARE_SIZE;x++) {
    grid_square[0][y][x]=x+(1+GRID_INDENT-GRID_SQUARE_SIZE);
    grid_square[1][y][x]=GRID_SQUARE_SIZE-1-x;
   }
  }
  for (;y<GRID_SQUARE_SIZE;y++) {
   int x;
   for (x=0;x<GRID_SQUARE_SIZE-1-y;x++) {
    grid_square[0][y][x]=GRID_INDENT-x;
    grid_square[1][y][x]=x;
   }
   for (;x<=y;x++) {
    grid_square[0][y][x]=y+(1+GRID_INDENT-GRID_SQUARE_SIZE);
    grid_square[1][y][x]=GRID_SQUARE_SIZE-1-y;
   }
   for (;x<GRID_SQUARE_SIZE;x++) {
    grid_square[0][y][x]=x+(1+GRID_INDENT-GRID_SQUARE_SIZE);
    grid_square[1][y][x]=GRID_SQUARE_SIZE-1-x;
   }
  }
 }
}

void draw_grid(BITMAP *bmp,float x,float y,float z,float st,float ct) {

 int below_grid;

 int ys;
 float yf,yf_step;

 if (z>=0.01) {
  below_grid=0;
 } else if (z<=-0.01) {
  below_grid=1;
  z=-z;
 } else return;

 ys=bmp->h>>1;
 yf_step=(3.0/4.0)/(bmp->h-ys);
 yf=yf_step;

//For the calculation of xw,yw,xw_step,yw_step; yw_step is filled last
#define xe yw_step

#define DRAW_GRID(size,put)\
 for (ys=bmp->h>>1;ys<bmp->h;ys++,yf+=yf_step) {                            \
  char *bptr=bmp->line[below_grid?bmp->h-1-ys:ys];                          \
  float ye=z/yf;                                                            \
  int xs;                                                                   \
  float xw,yw,xw_step,yw_step;                                              \
  xe=(-GRID_SQUARE_SIZE)*ye;                                                \
  xw=GRID_SQUARE_SIZE*(x+ye*st)+xe*ct;                                      \
  yw=GRID_SQUARE_SIZE*(y-ye*ct)+xe*st;                                      \
  xe/=-(bmp->w>>1);                                                         \
  xw_step=xe*ct;                                                            \
  yw_step=xe*st;                                                            \
  for (xs=0;xs<bmp->w;xs++,xw+=xw_step,yw+=yw_step) {                       \
   int xd=floor(xw);                                                        \
   int yd=floor(yw);                                                        \
   int xt=xd>>GRID_SQUARE_SHIFT;                                            \
   int yt=yd>>GRID_SQUARE_SHIFT;                                            \
   if (xt>=0 && xt<level->w && yt>=0 && yt<level->h) {                      \
    TILE t=level->tile[yt][xt];                                             \
    if (t) {                                                                \
     register int c=grid_col[grid_square[t-1][yd&(GRID_SQUARE_SIZE-1)]      \
                                             [xd&(GRID_SQUARE_SIZE-1)]];    \
     put                                                                    \
    }                                                                       \
   }                                                                        \
   bptr+=size;                                                              \
  }                                                                         \
 }

 switch (gfx_depth) {
  case 15:
  case 16:
   DRAW_GRID(2,*(unsigned short *)bptr=c;);
   break;
  case 24:
   DRAW_GRID(3,*(unsigned short *)bptr=c;bptr[2]=c>>16;);
   break;
  case 32:
   DRAW_GRID(4,*(unsigned int *)bptr=c;);
  default:
   DRAW_GRID(1,*bptr=c;);
 }
}
