#include "sheep.h"

int n_players;

PLAYER_INFO player_info[MAX_PLAYERS];
LEVEL *level;

int game_time;
int end_game;
int end_game_time;

int sheep_popper;
int winner;//bit mask, in case players tie
int winning_score;

int score_per_bubble;

void pop_sheep(int p) {

 sheep_popper=p;

 end_game=1;
 end_game_time=game_time+1000;

 pop_all_bubbles();

 process_winner();

}

void play_game(SHEEP_MENU *menu) {
 n_players=0;
 {
  int p;
  for (p=0;p<MAX_PLAYERS;p++) if (player_info[p].playing) n_players++;
 }
 if (n_players==0) {
  menu_message("You can't have a game","without any players!");
  return;
 }

 winner=0;

 {
  char *p=strchr(level_filename,0);
  strcpy(p,".lvl");
  level=load_level(level_filename);
  *p=0;
 }

 if (level==0) {
  menu_message("Could not load level",level_filename);
  return;
 }

 create_starfield();

 game_time=0;//this may be used in initialisation code
 end_game=0;
 end_game_time=-1;//will never equal game_time
 if (sheep_time) score_per_bubble=300/sheep_time;

 {
  int p;
  for (p=0;p<MAX_PLAYERS;p++) {
   if (player_info[p].playing) {
    player_info[p].score=0;

    position_player(&level->player[p]);
    //start player on grid
    level->player[p].z=1.0;
    level->player[p].zv=random()*(0.01/RAND_RANGE);
                                        //so that players don't hover in sync
   }
  }
 }

 get_views();

 {
  int b=0;
  for (b=0;b<level->n_bubbles;b++) initialise_bubble(&level->bubble[b]);
 }

 level->pop=0;

 start_timing();

 for (;;) {
  while (counter==0);
  while (counter) {

   if (game_time==REAL_SHEEP_TIME) {
    queue_message("SHEEP TIME",makecol(255,255,0));
    score_per_bubble=10*sheep_number;
   }

   update_starfield();

   update_pops();

   if (end_game==0) {
    {
     int p;
     for (p=0;p<MAX_PLAYERS;p++) if (player_info[p].playing) {
      propagate_player(p);
     }
    }

    {
     int b;
     for (b=0;b<level->n_bubbles;b++) propagate_bubble(&level->bubble[b]);
    }

    {
     int p;
     for (p=1;p<MAX_PLAYERS;p++) if (player_info[p].playing) {
      int q;
      for (q=0;q<p;q++) if (player_info[q].playing) {
       test_object_collision(
             &level->player[p].x, &level->player[p].y, &level->player[p].z,
             &level->player[p].xv,&level->player[p].yv,&level->player[p].zv,
             &level->player[q].x, &level->player[q].y, &level->player[q].z,
             &level->player[q].xv,&level->player[q].yv,&level->player[q].zv);
      }
     }
    }

    {
     int b;
     for (b=1;b<level->n_bubbles;b++) {
      int q;
      for (q=0;q<b;q++) {
       test_object_collision(
             &level->bubble[b].x, &level->bubble[b].y, &level->bubble[b].z,
             &level->bubble[b].xv,&level->bubble[b].yv,&level->bubble[b].zv,
             &level->bubble[q].x, &level->bubble[q].y, &level->bubble[q].z,
             &level->bubble[q].xv,&level->bubble[q].yv,&level->bubble[q].zv);
      }
     }
    }

    //test for player/bubble collision
    {
     int p;
     for (p=0;p<MAX_PLAYERS;p++) if (player_info[p].playing) {
      int b;
      for (b=0;b<level->n_bubbles;b++) {
       float xr=level->bubble[b].x-level->player[p].x;
       float yr=level->bubble[b].y-level->player[p].y;
       float zr=level->bubble[b].z-level->player[p].z;
       if (xr*xr+yr*yr+zr*zr<2.0*2.0) {//check if a collision has occurred
        player_info[p].score+=level->bubble[b].score;
        if (level->bubble[b].type==0) {
         //player has found a sheep! Baaah...
         {
          int vol,pan;
          originate_sample(level->bubble[b].x,level->bubble[b].y,
                                        level->bubble[b].z,1020.0,&vol,&pan);
          play_sample(dat[SFX0_POP].dat,vol,pan,1000,0);
         }
         pop_sheep(p);
         goto skip_player_bubble_collisions;
        } else {
         pop_bubble(&level->bubble[b]);
         initialise_bubble(&level->bubble[b]);
        }
       }
      }
     }
    }
skip_player_bubble_collisions:
   }

   update_messages();

   end_frame();

   game_time++;
   if (game_time==end_game_time) goto abort_game;
  }

  clear_to_color(scrbuf,makecol(0,0,64));
  draw_views();
  draw_messages();
  SCRBUF_TO_SCREEN;

  while (keypressed()) {
   if (readkey()>>8==KEY_ESC) goto abort_game;
  }
 }

abort_game:

 end_timing();
 end_messages();
 destroy_views();
 destroy_level(level);

 load_hiscores();
 {
  int n=record_scores();
  if (n) {
   save_hiscores();
   show_hiscore_table(n);
  }
 }
}
