#include "sheep.h"

#define EP_NAME 2
#define EP_COLOUR 4

int player_editing;
PLAYER_INFO *ep_info;

//these are defined in optplay.c
char *str_player0(void);
char *str_player1(void);
char *str_player2(void);
char *str_player3(void);

char *(*str_player[4])(void)={str_player0,str_player1,str_player2,str_player3};

SHEEP_MENU edit_player_menu[];

//This array is from exkeys.c, but modified.
char *key_name[]={
   "NOT SET     ","A           ","B           ","C           ",
   "D           ","E           ","F           ","G           ",
   "H           ","I           ","J           ","K           ",
   "L           ","M           ","N           ","O           ",
   "P           ","Q           ","R           ","S           ",
   "T           ","U           ","V           ","W           ",
   "X           ","Y           ","Z           ","0           ",
   "1           ","2           ","3           ","4           ",
   "5           ","6           ","7           ","8           ",
   "9           ","KEYPAD 0    ","KEYPAD 1    ","KEYPAD 2    ",
   "KEYPAD 3    ","KEYPAD 4    ","KEYPAD 5    ","KEYPAD 6    ",
   "KEYPAD 7    ","KEYPAD 8    ","KEYPAD 9    ","F1          ",
   "F2          ","F3          ","F4          ","F5          ",
   "F6          ","F7          ","F8          ","F9          ",
   "F10         ","F11         ","F12         ","ESC         ",
   "TILDE       ","MINUS       ","EQUALS      ","BACKSPACE   ",
   "TAB         ","OPENBRACE   ","CLOSEBRACE  ","ENTER       ",
   "COLON       ","QUOTE       ","BACKSLASH   ","BACKSLASH2  ",
   "COMMA       ","STOP        ","SLASH       ","SPACE       ",
   "INSERT      ","DEL         ","HOME        ","END         ",
   "PGUP        ","PGDN        ","LEFT        ","RIGHT       ",
   "UP          ","DOWN        ","KEYPAD SLASH","ASTERISK    ",
   "KEYPAD MINUS","KEYPAD PLUS ","KEYPAD DEL  ","KEYPAD ENTER",
   "PRTSCR      ","PAUSE       ","YEN         ","YEN2        ",
   "KANA        ","HENKAN      ","MUHENKAN    ",
   "LSHIFT      ","RSHIFT      ","LCONTROL    ","RCONTROL    ",
   "ALT         ","ALTGR       ","LWIN        ","RWIN        ",
   "MENU        ","SCRLOCK     ","NUMLOCK     ","CAPSLOCK    "};

#define STR_PLAYER_KEY(c)       \
char *str_player_key##c() {     \
 return key_name[ep_info->k.c]; \
}

STR_PLAYER_KEY(l)
STR_PLAYER_KEY(r)
STR_PLAYER_KEY(u)
STR_PLAYER_KEY(d)

int detect_key() {
 //tempstr is used to make sure we don't detect keys that were already held
 //down.
 memcpy(tempstr,(char *)key,KEY_MAX);
 for (;;) {
  unsigned char k;
  for (k=0;k<KEY_MAX;k++) if (k!=KEY_PAUSE) {
   if (tempstr[k]) {
    if (key[k]==0) tempstr[k]=0;
   } else {
    if (key[k]) return k;
   }
  }
 }
}

#define GET_KEY(name,symbol)              \
 draw_menu_message("Press key for",name); \
 {                                        \
  unsigned char k=detect_key();           \
  if (k==KEY_ESC) return 1;               \
  ep_info->k.symbol=k;                    \
 }

int set_player_keys(SHEEP_MENU *menu,int k) {
 switch (k>>8) {
  case KEY_ENTER:
  case KEY_SPACE:
   GET_KEY("LEFT",l)
   GET_KEY("RIGHT",r)
   GET_KEY("FORWARDS",u)
   GET_KEY("BACKWARDS",d)
   clear_keybuf();
   return 1;
 }
 return 0;
}

int change_player_name(SHEEP_MENU *menu,int k) {
 int l=strlen(ep_info->name);
 switch (k>>8) {
  case KEY_BACKSPACE:
  case KEY_DEL:
  case KEY_DEL_PAD:
   if (l) {
    ep_info->name[--l]=0;
    return 1;
   }
   break;
  default:
   k&=0xFF;
   if (l<MAX_NAME_LENGTH) {
    if (k>=' ' && k<='~') {
     ep_info->name[l++]=k;
     ep_info->name[l]=0;
     return 1;
    }
   }
 }
 return 0;
}

int change_player_colour(SHEEP_MENU *menu,int k) {
 switch (k>>8) {
  case KEY_LEFT:
  case KEY_4_PAD:
   {
    int old_colour=ep_info->colour;
restart_clash_l:
    ep_info->colour=(ep_info->colour+(N_PLAYER_COLOURS-1))%N_PLAYER_COLOURS;
    {
     int p;
     for (p=0;p<MAX_PLAYERS;p++) if (p!=player_editing) {
      if (ep_info->colour==player_info[p].colour) {
       if (player_info[p].playing) {
        goto restart_clash_l;
       } else {
        player_info[p].colour=old_colour;
        break;
       }
      }
     }
    }
   }
   edit_player_menu[EP_COLOUR].colour=ep_info->colour;
   return 1;
  case KEY_RIGHT:
  case KEY_6_PAD:
   {
    int old_colour=ep_info->colour;
restart_clash_r:
    ep_info->colour=(ep_info->colour+1)%N_PLAYER_COLOURS;
    {
     int p;
     for (p=0;p<MAX_PLAYERS;p++) if (p!=player_editing) {
      if (ep_info->colour==player_info[p].colour) {
       if (player_info[p].playing) {
        goto restart_clash_r;
       } else {
        player_info[p].colour=old_colour;
        break;
       }
      }
     }
    }
   }
   edit_player_menu[EP_COLOUR].colour=ep_info->colour;
   return 1;
 }
 return 0;
}

SHEEP_MENU edit_player_menu[]=
{{"Edit Player"        ,0              ,2,m_skip  ,0                   ,0},
 {""                   ,0              ,0,m_skip  ,0                   ,0},
 {"Name: "             ,0              ,1,m_normal,change_player_name  ,0},
 {"Change Colour"      ,0              ,3,m_normal,change_player_colour,0},
 {"THIS IS YOUR COLOUR",0              ,0,m_skip  ,0                   ,0},
 {""                   ,0              ,0,m_skip  ,0                   ,0},
 {"Set keys"           ,0              ,4,m_normal,set_player_keys     ,0},
 {""                   ,0              ,0,m_skip  ,0                   ,0},
 {"     Left: "        ,str_player_keyl,6,m_skip  ,0                   ,0},
 {"    Right: "        ,str_player_keyr,7,m_skip  ,0                   ,0},
 {" Forwards: "        ,str_player_keyu,8,m_skip  ,0                   ,0},
 {"Backwards: "        ,str_player_keyd,0,m_skip  ,0                   ,0},
 {""                   ,0              ,0,m_skip  ,0                   ,0},
 {"Accept Options"     ,0              ,5,m_exit  ,0                   ,0},
 {0                    ,0              ,0,0       ,0                   ,0}};

void do_edit_player() {
 ep_info=&player_info[player_editing];
 edit_player_menu[EP_NAME].str2=str_player[player_editing];
 edit_player_menu[EP_COLOUR].colour=ep_info->colour;
 do_sheep_menu(edit_player_menu,2);
}
