#include "sheep.h"

typedef struct {
 int x,y;
 float z;
 float w,h;
 int clip;
 int id;
 void (*draw)(BITMAP *bmp,float x,float y,float z,float w,float h,int id);
} DRAWOBJ;

DRAWOBJ drawobj[MAX_PLAYERS+MAX_BUBBLES+MAX_BUBBLES];
DRAWOBJ *drawobj_last;

int drawobj_compare(const void *e1,const void *e2) {
 if (((const DRAWOBJ *)e1)->z>((const DRAWOBJ *)e2)->z) return -1;
 return 1;
}

void sort_objects(BITMAP *bmp,float x,float y,float z,float st,float ct) {

 drawobj_last=drawobj;

 {
  int p;
  for (p=0;p<MAX_PLAYERS;p++) if (player_info[p].playing) {
   float xe=level->player[p].x-x;
   float ye=level->player[p].y-y;
   drawobj_last->z=xe*st-ye*ct;
   if (drawobj_last->z>=0.01) {
    drawobj_last->x=((xe*ct+ye*st)/drawobj_last->z+1.0)*(bmp->w>>1);
    drawobj_last->y=(0.5-(level->player[p].z-z)*(2.0/3.0)/drawobj_last->z)*bmp->h;
    drawobj_last->w=(bmp->w>>1)/drawobj_last->z;
    drawobj_last->h=(bmp->h*(2.0/3.0))/drawobj_last->z;
    //check range here, before unnecessary sorting occurs
    if (drawobj_last->x>=-drawobj_last->w &&
        drawobj_last->x<=bmp->w+drawobj_last->w &&
        drawobj_last->y>=-drawobj_last->h &&
        drawobj_last->y<=bmp->h+drawobj_last->h) {
     drawobj_last->clip=ceil((0.5+z*(2.0/3.0)/drawobj_last->z)*bmp->h);
     if (drawobj_last->clip<0) drawobj_last->clip=0;
               else if (drawobj_last->clip>bmp->h) drawobj_last->clip=bmp->h;
     drawobj_last->id=p;
     drawobj_last->draw=draw_player;
     drawobj_last++;
    }
   }
  }
 }

 if (end_game==0) {
  int b;
  for (b=0;b<level->n_bubbles;b++) {
   float xe=level->bubble[b].x-x;
   float ye=level->bubble[b].y-y;
   drawobj_last->z=xe*st-ye*ct;
   if (drawobj_last->z>=0.01) {
    drawobj_last->x=((xe*ct+ye*st)/drawobj_last->z+1.0)*(bmp->w>>1);
    drawobj_last->y=(0.5-(level->bubble[b].z-z)*(2.0/3.0)/drawobj_last->z)*bmp->h;
    drawobj_last->w=(bmp->w>>1)/drawobj_last->z;
    drawobj_last->h=(bmp->h*(2.0/3.0))/drawobj_last->z;
    //check range here, before unnecessary sorting occurs
    if (drawobj_last->x>=-drawobj_last->w &&
        drawobj_last->x<=bmp->w+drawobj_last->w &&
        drawobj_last->y>=-drawobj_last->h &&
        drawobj_last->y<=bmp->h+drawobj_last->h) {
     drawobj_last->clip=ceil((0.5+z*(2.0/3.0)/drawobj_last->z)*bmp->h);
     if (drawobj_last->clip<0) drawobj_last->clip=0;
               else if (drawobj_last->clip>bmp->h) drawobj_last->clip=bmp->h;
     drawobj_last->id=b;
     drawobj_last->draw=draw_bubble;
     drawobj_last++;
    }
   }
  }
 }

 {
  POP *pop=level->pop;
  while (pop) {
   float xe=pop->x-x;
   float ye=pop->y-y;
   drawobj_last->z=xe*st-ye*ct;
   if (drawobj_last->z>=0.01) {
    drawobj_last->x=((xe*ct+ye*st)/drawobj_last->z+1.0)*(bmp->w>>1);
    drawobj_last->y=(0.5-(pop->z-z)*(2.0/3.0)/drawobj_last->z)*bmp->h;
    drawobj_last->w=(bmp->w>>1)/drawobj_last->z;
    drawobj_last->h=(bmp->h*(2.0/3.0))/drawobj_last->z;
    //no range check, as pops are not limited to radius 1
    drawobj_last->clip=ceil((0.5+z*(2.0/3.0)/drawobj_last->z)*bmp->h);
    if (drawobj_last->clip<0) drawobj_last->clip=0;
               else if (drawobj_last->clip>bmp->h) drawobj_last->clip=bmp->h;
    drawobj_last->id=(int)pop;
    drawobj_last->draw=(void (*)
                       (BITMAP *,float,float,float,float,float,int))draw_pop;
    drawobj_last++;
   }
   pop=pop->next;
  }
 }

 qsort(drawobj,drawobj_last-drawobj,sizeof(DRAWOBJ),drawobj_compare);
}

void draw_objects_below_grid(BITMAP *bmp) {
 DRAWOBJ *obj=drawobj;
 while (obj!=drawobj_last) {
  bmp->ct=obj->clip;
  obj->draw(bmp,obj->x,obj->y,obj->z,obj->w,obj->h,obj->id);
  bmp->ct=0;
  obj++;
 }
}

void draw_objects_above_grid(BITMAP *bmp) {
 DRAWOBJ *obj=drawobj;
 while (obj!=drawobj_last) {
  bmp->cb=obj->clip;
  obj->draw(bmp,obj->x,obj->y,obj->z,obj->w,obj->h,obj->id);
  bmp->cb=bmp->h;
  obj++;
 }
}
