#include "sheep.h"

//This code assumes that all objects have radius 1.0.

#define IS_WALL(y,x) ((x)>=0 && (x)<level->w && (y)>=0 && (y)<level->h && \
                                               level->tile[(y)][(x)]==t_wall)

#define IS_FLOOR(y,x) ((x)>=0 && (x)<level->w && (y)>=0 && (y)<level->h && \
                                               level->tile[(y)][(x)]!=t_hole)

void play_bounce(float x,float y,float z,float i) {
 int vol,pan;
 originate_sample(x,y,z,1020.0*i,&vol,&pan);
 if (vol>=8) play_sample(dat[SFX3_BOUNCE].dat,vol,pan,881+(random()&255),0);
}

void test_object_collision(float *x1, float *y1, float *z1,
                           float *x1v,float *y1v,float *z1v,
                           float *x2, float *y2, float *z2,
                           float *x2v,float *y2v,float *z2v) {
 float xr,yr,zr;
 float r;

 //bounding box checks
 xr=*x2-*x1;
 if (xr<-2.0 || xr>2.0) return;
 yr=*y2-*y1;
 if (yr<-2.0 || yr>2.0) return;
 zr=*z2-*z1;
 if (zr<-2.0 || zr>2.0) return;

 r=xr*xr+yr*yr+zr*zr;

 if (r<2.0*2.0) {//check if a collision has occurred
  if (r<0.000001) {//just in case...
   xr=0;
   yr=0;
   zr=1;

   r=0.5;
  } else {
   r=sqrt(r);
   xr/=r;
   yr/=r;
   zr/=r;
   //(xr,yr,zr) is now normalised, and r is the former magnitude

   //adjust coordinates
   r=(2.0-r)/2.0;
  }
  *x1-=xr*r;
  *y1-=yr*r;
  *z1-=zr*r;
  *x2+=xr*r;
  *y2+=yr*r;
  *z2+=zr*r;

  //adjust velocity using component of v2-v1 in direction of xr,yr
  r=(*x2v-*x1v)*xr+(*y2v-*y1v)*yr+(*z2v-*z1v)*zr;
  if (r<0) {//check that the objects are actually moving into each other
   play_bounce((*x1+*x2)/2.0,(*y1+*y2)/2.0,(*z1+*z2)/2.0,r/-2.0);
   *x1v+=r*xr;
   *y1v+=r*yr;
   *z1v+=r*zr;
   *x2v-=r*xr;
   *y2v-=r*yr;
   *z2v-=r*zr;
  }
 }
}

void test_edge_collision(float *x,float *y,float *xv,float *yv,
                              float xf,float yf,float xa,float ya,float za) {
 //xf,yf indicates the point of contact
 float xr=*x-xf;
 float yr=*y-yf;
 float r=xr*xr+yr*yr;

 if (r>=1.0) return;//check if a collision has occurred

 r=sqrt(r);
 xr/=r;
 yr/=r;
 //(xr,yr) is now normalised, and r is the former magnitude

 //adjust coordinates
 r=1.0-r;
 *x+=xr*r;
 *y+=yr*r;

 //adjust velocity using 2 * (component of v in direction of xr,yr)
 r=2.0*(*xv*xr+*yv*yr);
 if (r<0) {//check that the object is actually moving into the wall
  play_bounce(xa,ya,za,r/-2.0);
  *xv-=r*xr;
  *yv-=r*yr;
 }
}

//zf is always 0 for this
void test_vertex_collision(float *x, float *y, float *z,
                           float *xv,float *yv,float *zv,float xf,float yf) {
 //xf,yf indicates the point of contact
 float xr=*x-xf;
 float yr=*y-yf;
 float zr=*z;
 float r=xr*xr+yr*yr+zr*zr;

 if (r>=1.0) return;//check if a collision has occurred

 r=sqrt(r);
 xr/=r;
 yr/=r;
 zr/=r;
 //(xr,yr,zr) is now normalised, and r is the former magnitude

 //adjust coordinates
 r=1.0-r;
 *x+=xr*r;
 *y+=yr*r;
 *z+=zr*r;

 //adjust velocity using 2 * (component of v in direction of xr,yr,zr)
 r=2.0*(*xv*xr+*yv*yr+*zv*zr);
 if (r<0) {//check that the object is actually moving into the wall
  play_bounce(xf,yf,0,r/-2.0);
  *xv-=r*xr;
  *yv-=r*yr;
  *zv-=r*zr;
 }
}

void collide_with_walls(float *x,float *y,float z,float *xv,float *yv) {
 int xf=floor(*x);
 int yf=floor(*y);
/*
 int yt_s=xf-1,yt_e=xf+1;
 int xt_s=xf-1,xt_e=xf+1;
 if (xt_s<0) xt_s=0;
 if (xt_e>=level->w) xt_e=level->w-1;
 if (yt_s<0) yt_s=0;
 if (yt_e>=level->h) yt_e=level->h-1;
*/
 int collided=0;

 if (IS_WALL(yf,xf-1)) {
  *x=xf+1;
  if (*xv<0) {*xv=-*xv; play_bounce(*x,*y,z,*xv);}
  collided=1;
 } else if (IS_WALL(yf,xf+1)) {
  *x=xf;
  if (*xv>0) {play_bounce(*x,*y,z,*xv); *xv=-*xv;}
  collided=1;
 }

 if (IS_WALL(yf-1,xf)) {
  *y=yf+1;
  if (*yv<0) {*yv=-*yv; play_bounce(*x,*y,z,*yv);}
  collided=1;
 } else if (IS_WALL(yf+1,xf)) {
  *y=yf;
  if (*yv>0) {play_bounce(*x,*y,z,*yv); *yv=-*yv;}
  collided=1;
 }

 if (collided) return;

 //consider a corner collision
 if (IS_WALL(yf-1,xf-1)) test_edge_collision(x,y,xv,yv,xf  ,yf  ,xf  ,yf  ,z);
 if (IS_WALL(yf-1,xf+1)) test_edge_collision(x,y,xv,yv,xf+1,yf  ,xf+1,yf  ,z);
 if (IS_WALL(yf+1,xf-1)) test_edge_collision(x,y,xv,yv,xf  ,yf+1,xf  ,yf+1,z);
 if (IS_WALL(yf+1,xf+1)) test_edge_collision(x,y,xv,yv,xf+1,yf+1,xf+1,yf+1,z);
}

void collide_with_floors(float *x, float *y, float *z,
                         float *xv,float *yv,float *zv) {
 int xf=floor(*x);
 int yf=floor(*y);

 //consider a straight forward collision with the grid's surface
 if (*z>0 && IS_FLOOR(yf,xf)) {
  *z=1.0;
  if (*zv<0) {*zv=-*zv; play_bounce(*x,*y,0,*zv);}
  return;
 }

 //consider an edge collision
 if (IS_FLOOR(yf,xf-1)) test_edge_collision(x,z,xv,zv,xf  ,0,xf  ,*y,0);
 if (IS_FLOOR(yf,xf+1)) test_edge_collision(x,z,xv,zv,xf+1,0,xf+1,*y,0);
 if (IS_FLOOR(yf-1,xf)) test_edge_collision(y,z,yv,zv,yf  ,0,*x,yf-1,0);
 if (IS_FLOOR(yf+1,xf)) test_edge_collision(y,z,yv,zv,yf+1,0,*x,yf+1,0);

 //consider a corner collision
 if (IS_FLOOR(yf-1,xf-1)) test_vertex_collision(x,y,z,xv,yv,zv,xf,yf);
 if (IS_FLOOR(yf-1,xf+1)) test_vertex_collision(x,y,z,xv,yv,zv,xf+1,yf);
 if (IS_FLOOR(yf+1,xf-1)) test_vertex_collision(x,y,z,xv,yv,zv,xf,yf+1);
 if (IS_FLOOR(yf+1,xf+1)) test_vertex_collision(x,y,z,xv,yv,zv,xf+1,yf+1);
}
