#include "sheep.h"

#define NOT_WALL(y,x) ((x)<0 || (x)>=level->w || (y)<0 || (y)>=level->h || \
                                               level->tile[(y)][(x)]!=t_wall)

void initialise_bubble(BUBBLE *bubble) {

 //choose random position out of those not occupied by walls
 {
  int n=0;
  {
   int y;
   for (y=-7;y<level->h+8;y++) {
    int x;
    for (x=-7;x<level->w+8;x++) {
     if (NOT_WALL(y-1,x-1) && NOT_WALL(y-1,x  ) &&
         NOT_WALL(y  ,x-1) && NOT_WALL(y  ,x  )) {
      n++;
      if (random()%n==0) {
       bubble->x=x;
       bubble->y=y;
      }
     }
    }
   }
  }
 }

 //choose random direction
 {
  float th=random()*(2*M_PI/RAND_RANGE);
  float v=0.05+random()*(0.05/RAND_RANGE);
  bubble->xv=sin(th)*v;
  bubble->yv=cos(th)*v;
 }

 //make bubble point inwards if it starts outside
 if (bubble->xv<0 ? (bubble->x<0.5) : (bubble->x>level->w-0.5))
                                                      bubble->xv=-bubble->xv;
 if (bubble->yv<0 ? (bubble->y<0.5) : (bubble->y>level->h-0.5))
                                                      bubble->yv=-bubble->yv;

 //start bubble at top, giving it a slightly randomised velocity
 bubble->z=Z_OUT_OF_VIEW;
 bubble->zv=-random()*(0.01/RAND_RANGE);

 //choose a type
 if (game_time>=REAL_SHEEP_TIME && random()%MAX_SHEEP_NUMBER<sheep_number) {
  bubble->type=0;//sheep
  bubble->score=1000;
 } else {
  bubble->type=1+(random()%(N_BUBBLE_TYPES-1));//something else
  bubble->score=score_per_bubble;
 }
}

void propagate_bubble(BUBBLE *bubble) {
 bubble->x+=bubble->xv;
 bubble->y+=bubble->yv;

 bubble->zv-=0.001;

 bubble->zv*=0.992;
 bubble->z+=bubble->zv;

 if (bubble->z>=0) {
  //test for collisions with walls
  collide_with_walls(&bubble->x ,&bubble->y, bubble->z,
                     &bubble->xv,&bubble->yv);
  if (bubble->z<1.0) {
   collide_with_floors(&bubble->x ,&bubble->y ,&bubble->z,
                       &bubble->xv,&bubble->yv,&bubble->zv);
  }
 } else if (bubble->z<-Z_OUT_OF_VIEW) {
  initialise_bubble(bubble);
 }
}

void draw_bubble(BITMAP *bmp,float x,float y,float z,float w,float h,int id) {
 stretch_sprite(bmp,dat[BUBBLE000+level->bubble[id].type].dat,
                                                            x-w,y-h,w*2,h*2);
 ellipse(bmp,x,y,w,h,makecol(255,255,255));
}