//-----------------------------------------------------------------------------
// File: diutil.h
//
// Desc: DirectInput support
//
// Copyright (C) 1995-1999 Microsoft Corporation. All Rights Reserved.
//-----------------------------------------------------------------------------
#ifndef DIUTIL_H
#define DIUTIL_H


// Prototypes
HRESULT DIUtil_Initialize( HWND hWnd );
HRESULT DIUtil_GetDevices( DIDEVICEINSTANCE** ppDevice, DWORD* pdwCount );
LPDIRECTINPUTDEVICE2 DIUtil_CreateDevice( HWND, DIDEVICEINSTANCE* pdidi );

BOOL    DIUtil_IsForceFeedback( LPDIRECTINPUTDEVICE2 );

VOID    DIUtil_CleanupDirectInput();





FFEFFECT* DIUtil_CreateEffect();

HRESULT DIUtil_SetupCustomEffect( FFEFFECT*, LPDIRECTINPUTDEVICE2 );
HRESULT DIUtil_SetupPeriodicEffect( FFEFFECT*, LPDIRECTINPUTDEVICE2 );

HRESULT DIUtil_SetupConstantForceEffect( FFEFFECT*, LPDIRECTINPUTDEVICE2, BOOL );
HRESULT DIUtil_SetupFireForceEffect( FFEFFECT*, LPDIRECTINPUTDEVICE2);


HRESULT DIUtil_PlayDirectionalEffect( FFEFFECT*, LONG );
HRESULT DIUtil_PlayEffect( FFEFFECT* );

VOID    DIUtil_DeleteEffect( FFEFFECT* );




// Constants used for scaling the input device
#define DEADZONE         0	          // 25% of the axis range
#define RANGE_MAX        128         // Maximum positive axis value
#define RANGE_MIN       -128         // Minimum negative axis value




#endif //DIUTIL_H


