#define COLOR_TABLE_H

#define BLACK			0
#define WHITE			1
#define LIGHT_GRAY		2
#define	LIGHT_GREY		LIGHT_GRAY
#define GRAY			3
#define GREY			GRAY
#define MID_GRAY		4
#define DARK_GRAY		5
#define DARK_GREY		DARK_GRAY
#define RED				6
#define PINK			7
#define ORANGE			8
#define YELLOW			9
#define GREEN			10
#define MAGENTA			11
#define TRANS			MAGENTA
#define CYAN			12
#define BLUE			13
#define COLOR_MAX		14

int color[COLOR_MAX];

void init_color_table() {
	color[BLACK]		= makecol(0,	0,	 0);
	color[WHITE]		= makecol(255,	255, 255);
	color[LIGHT_GRAY]	= makecol(192,	192, 192);
	color[GRAY]			= makecol(128,	128, 128);
	color[MID_GRAY]		= makecol(80,	80,	 80);
	color[DARK_GRAY]	= makecol(64,	64,	 64);
	color[RED]			= makecol(255,	0,	 0);
	color[PINK]			= makecol(255,	175, 175);
	color[ORANGE]		= makecol(255,	200, 0);
	color[YELLOW]		= makecol(255,	255, 0);
	color[GREEN]		= makecol(0,	255, 0);
	color[MAGENTA]		= makecol(255,	0,	 255);
	color[CYAN]			= makecol(0,	255, 255);
	color[BLUE]			= makecol(0,	0,	 255);
}