#include <allegro.h>
#include <assert.h>
#include <stdio.h>


struct {
    int tl, tr, bl, br;
} foo[32][16];

int main(int argc, char *argv[])
{
    if (argc < 3) {
        printf("usage: %s <bmp> <set name> <base tile name>\n", argv[0]);
        return -1;
    }

    allegro_init();
    install_timer();
    install_mouse();
    install_keyboard();

    set_color_depth(desktop_color_depth());
    set_gfx_mode(GFX_AUTODETECT_WINDOWED, 64, 64, 0, 0);

    BITMAP *data = load_bitmap(argv[1], NULL);
    if (!data) {
        printf("error loading %s\n", argv[1]);
        return -1;
    }

    set_gfx_mode(GFX_AUTODETECT_WINDOWED, data->w, data->h, 0, 0);
    BITMAP *dbuf = create_bitmap(data->w, data->h);
    assert(dbuf);

    show_mouse(screen);

    int w = data->w/64;
    int h = data->h/64;
    int redraw = 1;
    drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
    set_trans_blender(0x80, 0x80, 0x80, 0x80);

    while (!key[KEY_ESC]) {
        int tx = mouse_x / 64;
        int ty = mouse_y / 64;
        int qx = (mouse_x - tx*64);
        int qy = (mouse_y - ty*64);

        if (mouse_b & 1) {
            foo[ty][tx].tl = foo[ty][tx].tl || (qx < 32 && qy < 32);
            foo[ty][tx].tr = foo[ty][tx].tr || (qx > 32 && qy < 32);
            foo[ty][tx].bl = foo[ty][tx].bl || (qx < 32 && qy > 32);
            foo[ty][tx].br = foo[ty][tx].br || (qx > 32 && qy > 32);
            redraw = 1;
        }

        if (mouse_b & 2) {
            foo[ty][tx].tl = foo[ty][tx].tl && !(qx < 32 && qy < 32);
            foo[ty][tx].tr = foo[ty][tx].tr && !(qx > 32 && qy < 32);
            foo[ty][tx].bl = foo[ty][tx].bl && !(qx < 32 && qy > 32);
            foo[ty][tx].br = foo[ty][tx].br && !(qx > 32 && qy > 32);
            redraw = 1;
        }

        if (redraw) {
            redraw = 0;
            blit(data, dbuf, 0, 0, 0, 0, dbuf->w, dbuf->h);

            /* Draw marked. */
            for (ty = 0; ty < 32; ty++) {
                for (tx = 0; tx < 16; tx++) {
                    rect(dbuf, tx*64, ty*64, tx*64+64, ty*64+64, makecol(0xff, 0xff, 0xff));
                    if (foo[ty][tx].tl) rectfill(dbuf, tx*64,    ty*64,    tx*64+31, ty*64+31, makecol(0,0,255));
                    if (foo[ty][tx].tr) rectfill(dbuf, tx*64+32, ty*64,    tx*64+63, ty*64+31, makecol(0,0,255));
                    if (foo[ty][tx].bl) rectfill(dbuf, tx*64,    ty*64+32, tx*64+31, ty*64+63, makecol(0,0,255));
                    if (foo[ty][tx].br) rectfill(dbuf, tx*64+32, ty*64+32, tx*64+63, ty*64+63, makecol(0,0,255));
                }
            }

            scare_mouse();
            blit(dbuf, screen, 0, 0, 0, 0, dbuf->w, dbuf->h);
            unscare_mouse();
        }
    }

    /* Export. */
    int n_tiles = 0;
    {
        int tx, ty;
        for (ty = 0; ty < h; ty++) {
            for (tx = 0; tx < w; tx++) {
                if (!(foo[ty][tx].tl || 
                      foo[ty][tx].tr || 
                      foo[ty][tx].bl || 
                      foo[ty][tx].br))
                    continue;
                n_tiles++;
            }
        }
    }


    time_t now;
    time(&now);
    printf("/* generated by %s on %s */\n", argv[0], ctime(&now));
    printf("{ \"%s\", %d, {\n", argv[3], n_tiles);
    {
        int tx, ty;
        for (ty = 0; ty < h; ty++) {
            for (tx = 0; tx < w; tx++) {
                if (!(foo[ty][tx].tl || 
                      foo[ty][tx].tr || 
                      foo[ty][tx].bl || 
                      foo[ty][tx].br))
                    continue;
                n_tiles--;
                printf("\t{ \"%s-%03d\",\t{%d,%d,%d,%d} }%c \n",
                        argv[2], ty*w+tx, 
                        foo[ty][tx].tl, foo[ty][tx].tr,
                        foo[ty][tx].bl, foo[ty][tx].br,
                        (n_tiles == 0) ? '}' : ',');
            }
        }
    }
    printf("}\n");

    return 0;
}
