/* zippy.m,
 *
 * A unit that move slowly before activation, then suddenly charges at
 * the player.
 */

#include <assert.h>
#include <math.h>
#include "common.h"
#include "seborrhea/seborrhea.h"
#include "unit-seeking.h"
#include "units/zippy.h"


static SebFile *unit_data;


@implementation Zippy
+ derive_loadData(unit_data, "data/zippy");
+ derive_shutdown(unit_data);

- init
{
    [super init];

    health = 5;
    speed = 3.0;

    sprite = [unit_data getSebumByName:"body"];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];
    rotated_sprite = YES;

    chunk_colours = CHUNK_COFFEE;
    return self;
}

- (void) enableMovement
{
    [super enableMovement];

    if (flags & FLAG_MOVING_ENABLED) {
	Unit *ally = FIND_CLOSEST_ALLY(x, y);
	if (ally) {
	    speed = 12.0;
	    angle = angle_towards_unit(x, y, ally);
	    return;
	}
	else
	    flags &=~ FLAG_MOVING_ENABLED;
    }

    /* Move anyway, but slowly. */
    [super move];
}
@end
