/* wraith.m,
 */

#include "common.h"
#include "projectiles/fireball.h"
#include "seborrhea/seborrhea.h"
#include "units/wraith.h"


static SebFile *unit_data;


@implementation Wraith
+ (BOOL) loadPrerequisites
{
    return LOAD_PROJECTILE_DATA_FOR(Fireball);
}

+ derive_loadData(unit_data, "data/wraith");
+ derive_shutdown(unit_data);

- init
{
    [super init];

    health = 75;
    speed = 1.5;

    sprite = [unit_data getSebumByName:"body"];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];

    gun  = [[[SideWeapon newWithProjectile:[Fireball class]]
		setShotDelay:25]
	       setXDisplacement:15 YDisplacement:0];
    return self;
}
@end
