/* viking.m,
 *
 * A sonic-wave turret with two viking horns.  Can be nasty.
 */

#include "candy/turret.h"
#include "common.h"
#include "projectiles/shockwave.h"
#include "seborrhea/seborrhea.h"
#include "units/viking.h"


static SebFile *turret_data;
static SebAnimation *fire_anim;

/*------------------------------------------------------------*/

@interface VikingBaseDebris: Candy
@end

@interface VikingTurretDebris: TurretDebris
@end

/*------------------------------------------------------------*/

@implementation Viking
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Shockwave); }

+ (BOOL) loadData
{
    if (not [self loadData:&turret_data :"data/viking"])
	return NO;

    fire_anim = (SebAnimation *)[turret_data getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(turret_data);
    fire_anim = nil;
}

- init
{
    [super init];

    health = 80;

    sprite = [turret_data getSebumByName:"stand"];
    turret = [[SebAnimator new] setAnimation:fire_anim];
    w = [sprite width];
    h = [sprite height];

    gun = [[Weapon newWithProjectile:[Shockwave class]]
	      setShotDelay:60];

    base_debris   = [VikingBaseDebris class];
    turret_debris = [VikingTurretDebris class];
    chunk_colours = CHUNK_RED;
    return self;
}

- (void) fire
{
    if (gun && [gun fireFromX:x Y:y Angle:angle])
	[(SebAnimator *)turret setAnimation:fire_anim];
}
@end

/*------------------------------------------------------------*/

@implementation VikingBaseDebris
- init
{
    [super init];
    sprite = [turret_data getSebumByName:"deb"];
    return self;
}
@end

@implementation VikingTurretDebris
- init
{
    [super init];
    health = max_health = 80;
    sprite = [fire_anim getFrame:-1];
    return self;
}
@end
