/* turtle.m,
 *
 * Turtle combat!
 */

#include <math.h>
#include "candy/tank-track.h"
#include "common.h"
#include "rotate.h"
#include "map.h"
#include "projectiles/fireball.h"
#include "seborrhea/seborrhea.h"
#include "units/all-units.h"
#include "unit-seeking.h"
#include "units/turtle.h"


static SebFile *tank_data;

/*--------------------------------------------------------------*/

@interface TurtleTrack: TankTrack
@end

/*--------------------------------------------------------------*/

@implementation Turtle
+ (BOOL) loadPrerequisites
{
    return LOAD_PROJECTILE_DATA_FOR(Fireball);
}

+ derive_loadData(tank_data, "data/turtle");
+ derive_shutdown(tank_data);

- init
{
    [super init];

    health = 75;
    speed = 0.45;

    sprite = [[SebAnimatorManualWithDelay new] setAnimation:(SebAnimation *)
					       [tank_data getSebumByName:"turtle"]];
    turret = [tank_data getSebumByName:"turret"];
    w = [sprite width];
    h = [sprite height];

    gun = [[[PulseWeapon newWithProjectile:[Fireball class]]
	       setShotDelay:3 WaveDelay:45]
	      setShotsPerWave:5];

    tracks = [TurtleTrack class];
    track_separation_sq = SQ(14.0);

    chunk_colours = CHUNK_BLUE;
    return self;
}
@end


@implementation Turtle (Turret)
- (void) drawTurret:(BITMAP *)dest
{
    /* Displace the turret 3 pixels backwards, relative to the centre
       of the tank. */
    int x_ = -3.0 * cos(angle);
    int y_ = -3.0 * sin(angle);
    [self drawTurret:dest Displacement:x_ :-y_];
}
@end

/*--------------------------------------------------------------*/

@implementation TurtlePath
+ (BOOL) loadPrerequisites
{
    return LOAD_UNIT_DATA_FOR(Turtle, NO);
}

- init
{
    [super init];

    health = 60;
    speed = 0.45;
    the_way = (SebSpline *)[tank_data getSebumByName:"path"];

    sprite = [[SebAnimatorManualWithDelay new] setAnimation:(SebAnimation *)
					       [tank_data getSebumByName:"turtle"]];
    turret = [tank_data getSebumByName:"turret"];
    w = [sprite width];
    h = [sprite height];
    rotated_sprite = YES;

    gun = [[[PulseWeapon newWithProjectile:[Fireball class]]
	       setShotDelay:3 WaveDelay:45]
	      setShotsPerWave:5];

    tracks = [TurtleTrack class];
    track_separation_sq = SQ(14.0);

    flags |= FLAG_FIRING_ENABLED;
    chunk_colours = CHUNK_BLUE;
    return self;
}
@end


@implementation TurtlePath (Turret)
- (void) drawTurret:(BITMAP *)dest
{
    /* Displace the turret 3 pixels backwards, relative to the centre
       of the tank. */
    int x_ = -3.0 * cos(angle);
    int y_ = -3.0 * sin(angle);
    [self drawTurret:dest Displacement:x_ :-y_];
}
@end

/*--------------------------------------------------------------*/

@implementation TurtleTrack
- init
{
    [super init];
    health = max_track_life = 160;
    sprite = [tank_data getSebumByName:"tracks"];
    return self;
}
@end
