/* tripe.m,
 *
 * Triple barreled turret.
 */

#include "candy/turret.h"
#include "common.h"
#include "projectiles/plasma.h"
#include "seborrhea/seborrhea.h"
#include "sound.h"
#include "units/tripe.h"


static SebFile *turret_data;
static SebAnimation *fire_anim;

/*------------------------------------------------------------*/

@interface TripeBaseDebris: Candy
@end

@interface TripeTurretDebris: TurretDebris
@end

/*------------------------------------------------------------*/

@implementation Tripe
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Plasma); }

+ (BOOL) loadData
{
    if (not [self loadData:&turret_data :"data/tripe"])
	return NO;

    fire_anim = (SebAnimation *)[turret_data getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(turret_data);
    fire_anim = nil;
}

- init
{
    [super init];

    health = 140;
    critical_health = 70;

    sprite = [turret_data getSebumByName:"stand"];
    turret = [[SebAnimator new] setAnimation:fire_anim];
    w = [sprite width];
    h = [sprite height];

    /* Guns. */
    gun = [[[[OffcentreWeapon newWithProjectile:[Plasma class]]
		setShotDelay:60] setFireTics:0]
	      setXDisplacement:15 YDisplacement:0];
    lgun = [[[[OffcentreWeapon newWithProjectile:[Plasma class]]
		 setShotDelay:60] setFireTics:10]
	       setXDisplacement:15 YDisplacement:-8];
    rgun = [[[[OffcentreWeapon newWithProjectile:[Plasma class]]
		 setShotDelay:60] setFireTics:20]
	       setXDisplacement:15 YDisplacement:8];

    base_debris   = [TripeBaseDebris class];
    turret_debris = [TripeTurretDebris class];
    chunk_colours = CHUNK_SARDAUKAR;
    return self;
}

- free
{
    lgun = [lgun free];
    rgun = [rgun free];
    return [super free];
}

- (void) fire
{
    if ([gun fireFromX:x Y:y Angle:angle])
	[(SebAnimator *)turret setAnimation:fire_anim];

    [lgun fireFromX:x Y:y Angle:angle];
    [rgun fireFromX:x Y:y Angle:angle];
}
@end

/*------------------------------------------------------------*/

@implementation TripeBaseDebris
- init
{
    [super init];
    sprite = [turret_data getSebumByName:"deb"];
    return self;
}
@end

@implementation TripeTurretDebris
- init
{
    [super init];
    health = max_health = 90;
    sprite = [fire_anim getFrame:-1];
    return self;
}
@end
