/* trigger.m,
 *
 * Trigger to change the scroll rate of the map.
 */

#include <allegro.h>
#include <assert.h>
#include "common.h"
#include "map-editor/unit-editor.h"
#include "map.h"
#include "seborrhea/seborrhea.h"
#include "units/trigger.h"


static SebFile *trigger_sebum;


@implementation Trigger
+ derive_loadData(trigger_sebum, "data/trigger");
+ derive_shutdown(trigger_sebum);

- init
{
    [super init];

    sprite = [trigger_sebum getSebumByName:"trig"];
    w = [sprite width];
    h = 1;

    desired_scroll_rate = -0.6;

    return self;
}

- (void) activate
{
    [current_map setScrollRate:desired_scroll_rate :YES];
    [self delete];
}

	/* VariesScrollRate protocol stuff.*/
- setScrollRate:(double)rate_
{
    desired_scroll_rate = rate_;
    return self;
}

/* Format: desired_scroll_rate;x;y;a[;flags] */
- (char *) exportUnitProperties:(char *)str
{
    char str2[1024] = "\0";
    [super exportUnitProperties:str2];
    snprintf(str, sizeof(str2), "%f;%s", desired_scroll_rate, str2);
    return str;
}


- (void) importUnitProperties:(char *)str
{
    char str2[1024];
    float a;

    sscanf(str, "%f;%s", &a, str2);
    [super importUnitProperties:str2];
    desired_scroll_rate = a;
}
@end


@implementation Trigger (MapEditor)
- (void) drawMapEditorExtras:(BITMAP *)dest
{
    [super drawMapEditorExtras:dest];
    textprintf_centre(dest, font,
		      x-offsetX, y+10-offsetY, makecol(0x40, 0xa0, 0x40),
		      "scroll rate: %g", desired_scroll_rate);
}
@end
