/* stumpy.m,
 *
 * A ship that can change its direction of movement halfway.  Equipped
 * with two fireball barrels.
 */

#include <allegro.h>
#include "common.h"
#include "projectiles/fireball.h"
#include "seborrhea/seborrhea.h"
#include "units/stumpy.h"


static SebFile *unit_data;
static SebAnimation *fire_anim;


@implementation Stumpy
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Fireball); }

+ (BOOL) loadData
{
    if (not [self loadData:&unit_data :"data/stumpy"])
	return NO;

    fire_anim = (SebAnimation *)[unit_data getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(unit_data);
    fire_anim = nil;
}

- init
{
    [super init];

    health = 40;
    speed = 1.1;

    sprite = [[SebAnimator new] setAnimation:fire_anim];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];

    gun = [[[[DualWeapon newWithProjectile:[Fireball class]]
		setShotDelay:-40 WaveDelay:80]
	       setShotsPerWave:2]
	      setXDisplacement:13 YDisplacement:12];
    
    chunk_colours = CHUNK_BLUE;
    return self;
}

- (void) fireProjectiles
{
    if ([gun fireFromX:x Y:y])
	[(SebAnimator *)sprite resetAnimation];
}
@end
