/* stubby.m,
 *
 * Stumpies with more health, and auto-aiming rocket launcher.
 */

#include <allegro.h>
#include <math.h>
#include "common.h"
#include "map.h"
#include "projectiles/rocket.h"
#include "rotate.h"
#include "seborrhea/seborrhea.h"
#include "unit-seeking.h"
#include "units/stubby.h"


static SebFile *unit_data;


@implementation Stubby
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Rocket); }
+ derive_loadData(unit_data, "data/stubby");
+ derive_shutdown(unit_data);

- init
{
    [super init];

    health = 60;
    speed = 1.0;

    sprite = [unit_data getSebumByName:"stubby"];
    turret = [unit_data getSebumByName:"turret"];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];

    gun = [[[PulseWeapon newWithProjectile:[Rocket class]]
	       setShotDelay:10 WaveDelay:65]
	      setShotsPerWave:2];
    turret_angle = -M_PI_2;

    return self;
}

- (void) draw:(BITMAP *)dest
{
    [super draw:dest];

    if (turret)
	[turret drawTo:dest X:x-offsetX Y:y-offsetY-8 Angle:turret_angle];
}

- (enum THING_UPDATE_STATE) update
{
    desired_turret_angle = ANGLE_TO_CLOSEST_ALLY(x, y);
    limited_rotate(&turret_angle, desired_turret_angle, deg2rad(1.5));
    simplify_angle(&turret_angle);
    return [super update];
}

- (void) fireProjectiles
{
    [gun fireFromX:x Y:y-8 Angle:turret_angle];
}
@end
