/* strumble.m,
 *
 * STRUMBLE (strum' bul) n.:
 *	That invisible object you always pretend made you trip, when
 *	it was actually your own stupid clumsiness.
 *		-- Rich Hall, "Sniglets"
 */

#include <allegro.h>
#include <math.h>
#include "candy/speed-shadow.h"
#include "common.h"
#include "map-editor/unit-editor.h"
#include "map-editor/unit-extras.h"
#include "seborrhea/seborrhea.h"
#include "sound.h"
#include "units/strumble.h"


static SebFile *unit_data;
static SebAnimation *move_anim, *thrust_anim;

/*------------------------------------------------------------*/

@interface StrumbleSpeedShadow: SpeedShadow
@end

/*------------------------------------------------------------*/

@implementation Strumble
+ (BOOL) loadData
{
    if (not [self loadData:&unit_data :"data/strumble"])
	return NO;

    move_anim = (SebAnimation *)[unit_data getSebumByName:"move-anim"];
    thrust_anim = (SebAnimation *)[unit_data getSebumByName:"thrust"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(unit_data);
    move_anim = nil;
    thrust_anim = nil;
}

- init
{
    [super init];

    health = 30;
    speed = 4.0;
    angle = M_PI_2;
    activate_y = -screen_h;

    sprite = [[SebAnimator new] setAnimation:move_anim];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height] - 4;

    chunk_colours = CHUNK_COFFEE;
    return self;
}

- (void) move
{
    [super move];

    if (move_phase == 0) {
	if (speed > 3.0)
	    speed -= 0.01;
	else {
	    move_phase = 1;
	    play_panned_sample((Sebum<SebSample> *)[unit_data getSebumByName:"snd"], x);
	    sprite = [(SebAnimator *)sprite setAnimation:thrust_anim];
	}
    }
    else {
	if (++move_phase == 3) {
	    move_phase = 1;
	    spawn_candy([StrumbleSpeedShadow class], x, y, MEDIUM_LAYER);
	}
	speed += 0.08;
    }
}

- derive_fixedAngle;
@end


@implementation Strumble (MapEditor)
- (void) drawMapEditorExtras:(BITMAP *)dest
{
    [super drawMapEditorExtras:dest];
    draw_fixed_activation_line(dest, x, y, activate_y);
}
@end

/*------------------------------------------------------------*/

@implementation StrumbleSpeedShadow
- init
{
    [super init];

    health = max_health = 8;
    speed = 0.5;
    angle = M_PI_2;

    sprite = [unit_data getSebumByName:"speedy"];

    return self;
}
@end
