/* stone.m,
 *
 * Light-ish turrets that scatter lots of fireballs.
 */

#include "candy/turret.h"
#include "common.h"
#include "projectiles/fireball.h"
#include "seborrhea/seborrhea.h"
#include "units/stone.h"


static SebFile *turret_data;
static SebAnimation *fire_anim;

/*------------------------------------------------------------*/

@interface StoneBaseDebris: Candy
@end

@interface StoneTurretDebris: TurretDebris
@end

/*------------------------------------------------------------*/

@implementation Stone
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Fireball); }

+ (BOOL) loadData
{
    if (not [self loadData:&turret_data :"data/stone"])
	return NO;

    fire_anim = (SebAnimation *)[turret_data getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(turret_data);
    fire_anim = nil;
}

- init
{
    [super init];

    health = 50;

    sprite = [turret_data getSebumByName:"stand"];
    turret = [[SebAnimator new] setAnimation:fire_anim];
    w = [sprite width];
    h = [sprite height];

    gun = [[[PulseWeapon newWithProjectile:[Fireball class]]
	       setShotDelay:5 WaveDelay:50]
	      setShotsPerWave:4];

    base_debris   = [StoneBaseDebris class];
    turret_debris = [StoneTurretDebris class];
    chunk_colours = CHUNK_RED;
    return self;
}

- (void) fire
{
    if (gun && [gun fireFromX:x Y:y Angle:angle])
	[(SebAnimator *)turret setAnimation:fire_anim];
}
@end

/*------------------------------------------------------------*/

@implementation StoneBaseDebris
- init
{
    [super init];
    sprite = [turret_data getSebumByName:"deb"];
    return self;
}
@end

@implementation StoneTurretDebris
- init
{
    [super init];
    health = max_health = 75;
    sprite = [fire_anim getFrame:-1];
    return self;
}
@end
