/* spirtle.m,
 *
 * SPIRTLE (spur' tul) n.:
 *	The fine stream from a grapefruit that always lands right in
 *	your eye.
 *		-- Rich Hall, "Sniglets"
 */

#include <allegro.h>
#include <math.h>
#include "common.h"
#include "seborrhea/seborrhea.h"
#include "unit-seeking.h"
#include "units/spirtle.h"


#define SPIRTLE_SPEED			7.2


static SebFile *unit_data;

/*--------------------------------------------------------------*/

@implementation BasicSpirtle
+ derive_loadData(unit_data, "data/spirtle");
+ derive_shutdown(unit_data);

- init
{
    [super init];

    health = 80;
    speed = SPIRTLE_SPEED;

    sprite = [unit_data getSebumByName:"body"];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];
    rotated_sprite = YES;

    flags |= FLAG_MOVING_ENABLED;
    chunk_colours = CHUNK_COFFEE;
    return self;
}

- (enum INACTIVE_UNIT_UPDATE_STATE) readyToActivate
{
    enum INACTIVE_UNIT_UPDATE_STATE r = [super readyToActivate];

    if (r == INACTIVE_UNIT_ACTIVATE) {
	if (not [self findTarget])
	    return INACTIVE_UNIT_REST;
    }

    return r;
}

- (BOOL) findTarget
{
    Unit *target = FIND_CLOSEST_ALLY(x, y);
    double dummy;

    if (not target)
	return NO;

    [target getX:&end_x Y:&dummy];
    return YES;
}

- derive_fixedAngle;
@end

/*--------------------------------------------------------------*/

@implementation Spirtle
- init
{
    [super init];
    angle = 0;
    activate_y = -50;
    return self;
}

- (void) move
{
    [super move];

    if (x >= end_x - 90 / 2.5 * SPIRTLE_SPEED + 100) {
	if (angle > deg2rad(-90.0))
	    angle -= deg2rad(2.5);
	else
	    angle = deg2rad(-90.0);
    }
}
@end

/*--------------------------------------------------------------*/

@implementation SpirtleMirror
- init
{
    [super init];
    angle = -M_PI;
    activate_y = -50;
    return self;
}

- (void) move
{
    [super move];

    if (x <= end_x + 90 / 2.5 * SPIRTLE_SPEED - 100) {
	if (angle < deg2rad(-90.0))
	    angle += deg2rad(2.5);
	else
	    angle = deg2rad(-90.0);
    }
}
@end

/*--------------------------------------------------------------*/
/* Special hack Spritles for Khan. */

@implementation SuperSpirtle
- init
{
    [super init];
    angle = 0;
    health = 120;
    speed = 8.2;
    return self;
}

- (void) move
{
    [super move];

    if (sign < 0) {
	if (x <= end_x + 90 / 3.5 * SPIRTLE_SPEED - 30) {
	    if (angle < deg2rad(-95.0))
		angle += deg2rad(3.5);
	    else
		angle = deg2rad(-95.0);
	}
    }
    else {
	if (x >= end_x - 90 / 3.5 * SPIRTLE_SPEED + 30) {
	    if (angle > deg2rad(-85.0))
		angle -= deg2rad(3.5);
	    else
		angle = deg2rad(-85.0);
	}
    }
}

- (void) setDestX:(int)xx :(BOOL)mirror
{
    end_x = xx;
    sign = mirror ? -1 : 1;

    if (mirror)
	angle = -M_PI;
    else
	angle = 0;
}
@end
