/* sea-dog.m,
 */

#include <math.h>
#include "candy/boat-sinking.h"
#include "candy/ripple.h"
#include "common.h"
#include "map-editor/unit-editor.h"
#include "map-editor/unit-extras.h"
#include "projectiles/pulse-laser.h"
#include "seborrhea/seborrhea.h"
#include "units/all-units.h"
#include "units/sea-dog.h"


static SebFile *boat_data;

/*--------------------------------------------------------------*/

@interface SeaDogSinking: BoatSinking
@end

/*--------------------------------------------------------------*/
/* SeaDog Abstract Class.					*/
/*--------------------------------------------------------------*/

@implementation BasicSeaDog
+ (BOOL) loadPrerequisites
{
    return LOAD_PROJECTILE_DATA_FOR(PulseLaser);
}

+ derive_loadData(boat_data, "data/sea-dog");
+ derive_shutdown(boat_data);

- init
{
    [super init];

    left_gun = [[[OffcentreWeapon newWithProjectile:[PulseLaser class]]
		    setShotDelay:15]
		   setXDisplacement:15 YDisplacement:-9];
    right_gun = [[[OffcentreWeapon newWithProjectile:[PulseLaser class]]
		     setShotDelay:15]
		    setXDisplacement:15 YDisplacement:9];

    sprite = [boat_data getSebumByName:"body"];
    w = [sprite width];
    h = [sprite height];
    rotated_sprite = YES;

    flags |= FLAG_FIRING_ENABLED;
    chunk_colours = CHUNK_RED;
    return self;
}

- free
{
    left_gun  = [left_gun  free];
    right_gun = [right_gun free];
    return [super free];
}

- (void) die
{
    [spawn_candy([SeaDogSinking class], x, y, FLOOR_LAYER) setAngle:angle];
    [super die];
}

- (void) move
{
    if (flags & FLAG_DYING)
	return;

    if (SQ(x - last_ripple_x) + SQ(y - last_ripple_y) >= SQ(6.0)) {
	double delta_x, delta_y;

	last_ripple_x = x;
	last_ripple_y = y;

 	delta_x = 8*sin(angle) - 20*sin(angle+M_PI_2);
	delta_y = 8*cos(angle) - 20*cos(angle+M_PI_2);
	spawn_candy([Ripple class], x+delta_x, y+delta_y, FLOOR_LAYER);

 	delta_x = -8*sin(angle) - 20*sin(angle+M_PI_2);
	delta_y = -8*cos(angle) - 20*cos(angle+M_PI_2);
	spawn_candy([Ripple class], x+delta_x, y+delta_y, FLOOR_LAYER);
    }

    [super move];
}

- (void) fire
{
    [left_gun  fireFromX:x Y:y Angle:angle-deg2rad(1.2)];
    [right_gun fireFromX:x Y:y Angle:angle+deg2rad(1.2)];
}
@end


@implementation BasicSeaDog (MapEditor)
- (void) drawMapEditorExtras:(BITMAP *)dest
{
    [super drawMapEditorExtras:dest];
    draw_fixed_activation_line(dest, x, y, activate_y);
}
@end

/*--------------------------------------------------------------*/

@implementation SeaDogSweeper
+ (BOOL) loadPrerequisites
{
    return LOAD_UNIT_DATA_FOR(BasicSeaDog, NO);
}

- init
{
    [super init];

    health = 40;
    speed = 6.5;

    the_way = (SebSpline *)[boat_data getSebumByName:"path"];
    activate_y = -300;
    return self;
}

- setX:(double)x_ Y:(double)y_
{
    [super setX:x_ Y:y_];

    /* This is really just to look good in the map editor. */
    if (x < screen_w / 2)
	angle = 0;
    else
	angle = M_PI;

    return self;
}
@end

/*--------------------------------------------------------------*/

@implementation SeaDogSinking
- init
{
    [super init];
    sprite = [[SebAnimator new] setAnimation:(SebAnimation *)
				[boat_data getSebumByName:"deb"]];
    return self;
}
@end
