/* sea-cucumber.m,
 *
 * A floating vulcan turret.
 */

#include <math.h>
#include "candy/boat-sinking.h"
#include "candy/turret.h"
#include "common.h"
#include "projectiles/evil-vulcan.h"
#include "seborrhea/seborrhea.h"
#include "units/sea-cucumber.h"


static SebFile *turret_data;

/*--------------------------------------------------------------*/

@interface SeaCucumberSinking: BoatSinking
@end

@interface SeaCucumberTurret: TurretDebris
@end

/*--------------------------------------------------------------*/

@implementation SeaCucumber
+ (BOOL) loadPrerequisites
{
    return LOAD_PROJECTILE_DATA_FOR(EvilVulcan);
}

+ derive_loadData(turret_data, "data/sea-cucumber");
+ derive_shutdown(turret_data);

- init
{
    [super init];

    health = 70;
    speed = 0.0;

    sprite = [turret_data getSebumByName:"body"];
    turret = [turret_data getSebumByName:"turret"];
    w = [sprite width];
    h = [sprite height];

    gun = [[[[SprayWeapon newWithProjectile:[EvilVulcan class]]
		setShotDelay:25]
	       setShotsPerWave:3]
	      setSpray:deg2rad(3.0)];

    base_debris = [SeaCucumberSinking class];
    turret_debris = [SeaCucumberTurret class];

    chunk_colours = CHUNK_BLUE;
    return self;
}
@end


@implementation SeaCucumber (Turret)
- (void) drawTurret:(BITMAP *)dest
{
    /* Displace the turret 2 pixels backwards, relative to the centre
       of the tank. */
    int x_ = -2.0 * cos(angle);
    int y_ = -2.0 * sin(angle);
    [self drawTurret:dest Displacement:x_ :-y_];
}
@end

/*--------------------------------------------------------------*/

@implementation SeaCucumberSinking
- init
{
    [super init];
    sprite = [[SebAnimator new] setAnimation:(SebAnimation *)
				[turret_data getSebumByName:"deb"]];
    angle = -M_PI_2;
    return self;
}
@end

@implementation SeaCucumberTurret
- init
{
    [super init];
    sprite = [turret_data getSebumByName:"turret"];
    return self;
}
@end
