/* schemer.m,
 *
 * Stronger versions of Deceivers that also fire.
 * Zelda: "I have scheme!"
 * Helda: "I want scheme!"
 */

#include <allegro.h>
#include "common.h"
#include "projectiles/plasma.h"
#include "seborrhea/seborrhea.h"
#include "units/schemer.h"


static SebFile *unit_data;


@implementation Schemer
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Plasma); }
+ derive_loadData(unit_data, "data/schemer");
+ derive_shutdown(unit_data);

- init
{
    [super init];

    health = 50;
    speed = 2.3;
    angle = 0.0;

    sprite = [unit_data getSebumByName:"schemer"];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];
    
    gun = [[Weapon newWithProjectile:[Plasma class]]
	      setShotDelay:80];

    activate_y = -200;
    return self;
}

- (void) fireProjectiles { [gun fireFromX:x Y:y Angle:angle]; }
@end
