/* red-back.m,
 */

#include <allegro.h>
#include <math.h>
#include "candy/tank-track.h"
#include "common.h"
#include "map.h"
#include "projectiles/rocket.h"
#include "seborrhea/seborrhea.h"
#include "units/red-back.h"


static SebFile *tank_data;

/*--------------------------------------------------------------*/

@interface SpiderTrack: TankTrack
@end

/*--------------------------------------------------------------*/

@implementation RedBackSpider
+ derive_loadData(tank_data, "data/red-back");
+ derive_shutdown(tank_data);

- init
{
    [super init];

    health = 120;
    critical_health = 60;
    speed = 0.50;

    sprite = [[SebAnimatorManualWithDelay new]
		 setAnimation:(SebAnimation *)
		 [tank_data getSebumByName:"move-anim"]];
    turret = [[SebAnimator new] setAnimation:(SebAnimation *)
				[tank_data getSebumByName:"fire-anim"]];
    w = [sprite width];
    h = [sprite height];

    gun = [[[PulseWeapon newWithProjectile:[Rocket class]]
	       setShotDelay:5 WaveDelay:50]
	      setShotsPerWave:3];

    tracks = [SpiderTrack class];
    track_separation_sq = SQ(24.0);

    return self;
}

- (void) drawTurret:(BITMAP *)dest
{
    /* Displace the turret 5px backwards and 7px upwards. */
    if (turret) {
	double sin_theta = sin(angle);
	double cos_theta = cos(angle);
	double x_ = x + (-5.0 * cos_theta) + (-7.0 * sin_theta) - offsetX;
	double y_ = y - (-5.0 * sin_theta) + (-7.0 * cos_theta) - offsetY;

	[turret drawTo:dest X:x_ Y:y_ Angle:turret_angle];
    }
}

- (void) fire
{
    if ([gun fireFromX:x Y:y Angle:turret_angle]) {
	[(SebAnimator *)turret resetAnimation];
    }
}
@end

/*--------------------------------------------------------------*/

@implementation SpiderTrack
- init
{
    [super init];
    /* Very long imprints in the snow. */
    health = max_track_life = 300;
    sprite = [tank_data getSebumByName:"tracks"];
    return self;
}
@end
