/* polar-bear.m,
 */

#include <assert.h>
#include <math.h>
#include "candy/tank-track.h"
#include "common.h"
#include "projectiles/pulse-laser.h"
#include "seborrhea/seborrhea.h"
#include "units/polar-bear.h"


static SebFile *tank_data;

/*--------------------------------------------------------------*/

@interface BearTrack: TankTrack
@end

/*--------------------------------------------------------------*/

@implementation PolarBear
+ (BOOL) loadPrerequisites
{
    return LOAD_PROJECTILE_DATA_FOR(PulseLaser);
}

+ derive_loadData(tank_data, "data/polar-bear");
+ derive_shutdown(tank_data);

- init
{
    [super init];

    health = 280;
    critical_health = 100;
    speed = 0.55;
    turret_rot_speed = deg2rad(3.0);

    sprite = [[SebAnimatorManualWithDelay new] setAnimation:(SebAnimation *)
					       [tank_data getSebumByName:"body"]];
    turret = [tank_data getSebumByName:"turret"];
    w = [sprite width];
    h = [sprite height];

    gun = [[[PulseWeapon newWithProjectile:[PulseLaser class]]
	       setShotDelay:5 WaveDelay:35]
	      setShotsPerWave:2];

    tracks = [BearTrack class];
    track_separation_sq = SQ(16.0);

    chunk_colours = CHUNK_BLUE;
    return self;
}
@end


@implementation PolarBear (Turret)
- (void) drawTurret:(BITMAP *)dest
{
    /* Displace the turret 7 pixels backwards, relative to the centre
       of the tank. */
    int x_ = -7.0 * cos(angle);
    int y_ = -7.0 * sin(angle);
    [self drawTurret:dest Displacement:x_ :-y_];
}
@end

/*--------------------------------------------------------------*/

@implementation BearTrack
- init
{
    [super init];
    health = max_track_life = 160;
    sprite = [tank_data getSebumByName:"tracks"];
    return self;
}
@end
