/* plump.m,
 */

#include <assert.h>
#include <math.h>
#include "common.h"
#include "projectiles/rocket.h"
#include "seborrhea/seborrhea.h"
#include "units/plump.h"


static SebFile *unit_data;


@implementation Plump
+ (BOOL) loadPrerequisites
{
    return LOAD_PROJECTILE_DATA_FOR(Rocket);
}

+ derive_loadData(unit_data, "data/plump");
+ derive_shutdown(unit_data);

- init
{
    [super init];

    health = 270;
    speed = 0.5;

    sprite = [[SebAnimator new] setAnimation:(SebAnimation *)
				[unit_data getSebumByName:"body"]];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width] - 10;
    h = [sprite height] - 12;

    gun = [[[PulseWeapon newWithProjectile:[Rocket class]]
	       setShotDelay:3 WaveDelay:40]
	      setShotsPerWave:5];

    rgun = [[[PulseWeapon newWithProjectile:[Rocket class]]
		setShotDelay:3 WaveDelay:40]
	       setShotsPerWave:5];

    return self;
}

- free
{
    rgun = [rgun free];
    return [super free];
}

- (void) fire
{
    int n = [(<PulseWeapon>)gun currentShot];

    [gun  fireFromX:x-10 Y:y+12 Angle:deg2rad(-95.0 - 2.0*n)];
    [rgun fireFromX:x+10 Y:y+12 Angle:deg2rad(-85.0 + 2.0*n)];
}
@end
