/* newt.m,
 *
 * A fast, light-ish tank.
 */

#include <allegro.h>
#include <math.h>
#include "candy/tank-track.h"
#include "candy/turret.h"
#include "common.h"
#include "projectiles/fireball.h"
#include "seborrhea/seborrhea.h"
#include "units/newt.h"


static SebFile *tank_data;
static SebAnimation *move_anim, *fire_anim;

/*------------------------------------------------------------*/

@interface NewtTrack: TankTrack
@end

@interface NewtTurretDebris: TurretDebris
@end

/*------------------------------------------------------------*/

@implementation Newt
+ (BOOL) loadPrerequisites
{
    return LOAD_PROJECTILE_DATA_FOR(Fireball);
}

+ (BOOL) loadData
{
    if (not [self loadData:&tank_data :"data/newt"])
	return NO;

    move_anim = (SebAnimation *)[tank_data getSebumByName:"move-anim"];
    fire_anim = (SebAnimation *)[tank_data getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(tank_data);
    move_anim = nil;
    fire_anim = nil;
}

- init
{
    [super init];

    health = 50;
    speed = 1.0;
    activate_y = -100;

    sprite = [[SebAnimatorManualWithDelay new] setAnimation:move_anim];
    turret = [[SebAnimator new] setAnimation:fire_anim];
    w = [sprite width];
    h = [sprite height];

    gun = [[Weapon newWithProjectile:[Fireball class]]
	      setShotDelay:70];

    turret_debris = [NewtTurretDebris class];
    tracks = [NewtTrack class];
    track_separation_sq = SQ(15.0);

    chunk_colours = CHUNK_GREEN;
    return self;
}

- (void) fire
{
    if ([gun fireFromX:x Y:y Angle:turret_angle])
	[(SebAnimator *)turret resetAnimation];
}
@end


@implementation Newt (Turret)
- (void) drawTurret:(BITMAP *)dest
{
    /* Displace the turret 9 pixels backwards, relative to the centre
       of the tank. */
    int x_ = -9.0 * cos(angle);
    int y_ = -9.0 * sin(angle);
    [self drawTurret:dest Displacement:x_ :-y_];
}
@end

/*------------------------------------------------------------*/

@implementation NewtTrack
- init
{
    [super init];
    health = max_track_life = 100;
    sprite = [tank_data getSebumByName:"tracks"];
    return self;
}
@end


@implementation NewtTurretDebris
- init
{
    [super init];
    health = max_health = 60;
    sprite = [fire_anim getFrame:-1];
    return self;
}
@end
